/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.ex.UIAssertionError;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.reporters.ExitCodeListener;

@ParametersAreNonnullByDefault
public class ScreenShooter
extends ExitCodeListener {
    private static final Logger log = LoggerFactory.getLogger(ScreenShooter.class);
    public static boolean captureSuccessfulTests;

    public void onTestStart(ITestResult result) {
        super.onTestStart(result);
        String className = result.getMethod().getTestClass().getName();
        String methodName = result.getMethod().getMethodName();
        Screenshots.startContext((String)className, (String)methodName);
    }

    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        if (!(result.getThrowable() instanceof UIAssertionError)) {
            log.info(Screenshots.saveScreenshotAndPageSource());
        }
        Screenshots.finishContext();
    }

    public void onTestSuccess(ITestResult result) {
        super.onTestSuccess(result);
        if (captureSuccessfulTests) {
            log.info(Screenshots.saveScreenshotAndPageSource());
        }
        Screenshots.finishContext();
    }
}

