/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.logevents.SoftAssertsErrorsCollector;
import com.codeborne.selenide.testng.Annotations;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;
import org.testng.reporters.ExitCodeListener;

public class SoftAsserts
extends ExitCodeListener {
    public static boolean fullStacktraces = true;

    public void onTestStart(ITestResult result) {
        this.addSelenideErrorListener(result);
    }

    public void onTestFailure(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onTestSuccess(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        this.failIfErrors(result);
    }

    public void beforeConfiguration(ITestResult result) {
        this.addSelenideErrorListener(result);
    }

    void addSelenideErrorListener(ITestResult result) {
        if (!SelenideLogger.hasListener((String)"softAssert") && this.isTestClassApplicableForSoftAsserts(result) && this.isTestMethodApplicableForSoftAsserts(result)) {
            SelenideLogger.addListener((String)"softAssert", (LogEventListener)new SoftAssertsErrorsCollector());
        }
    }

    private boolean isTestClassApplicableForSoftAsserts(ITestResult result) {
        return this.isTestClassApplicableForSoftAsserts(result.getTestClass().getRealClass());
    }

    boolean isTestClassApplicableForSoftAsserts(Class<?> testClass) {
        Listeners listenersAnnotation = this.getListenersAnnotation(testClass);
        return listenersAnnotation != null && Arrays.asList(listenersAnnotation.value()).contains(SoftAsserts.class);
    }

    private boolean isTestMethodApplicableForSoftAsserts(ITestResult result) {
        return this.isTestMethodApplicableForSoftAsserts(result.getMethod().getConstructorOrMethod().getMethod());
    }

    boolean isTestMethodApplicableForSoftAsserts(@Nullable Method testMethod) {
        if (testMethod == null) {
            return false;
        }
        Test annotation = Annotations.annotation(testMethod, Test.class);
        return annotation == null || Arrays.asList(annotation.expectedExceptions()).isEmpty();
    }

    @Nullable Listeners getListenersAnnotation(Class<?> testClass) {
        Listeners annotation = Annotations.annotation(testClass, Listeners.class);
        return annotation != null ? annotation : (testClass.getSuperclass() != null ? this.getListenersAnnotation(testClass.getSuperclass()) : null);
    }

    private void failIfErrors(ITestResult result) {
        AssertionError assertionError;
        ErrorsCollector errorsCollector = (ErrorsCollector)SelenideLogger.removeListener((String)"softAssert");
        if (errorsCollector != null && (assertionError = errorsCollector.cleanAndGetAssertionError(this.testName(result), result.getThrowable(), fullStacktraces)) != null) {
            result.setStatus(2);
            result.setThrowable((Throwable)((Object)assertionError));
        }
    }

    private String testName(ITestResult result) {
        return result.getTestClass().getName() + "." + result.getName();
    }
}

