/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Condition {
    public static final Condition visible = new Condition("visible"){

        public boolean apply(WebElement element) {
            return element != null && element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    public static final Condition hidden = new Condition("hidden"){

        public boolean apply(WebElement element) {
            return element == null || !element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    private final String name;

    public static Condition hasAttribute(final String attributeName, final String attributeValue) {
        return new Condition("hasAttribute"){

            public boolean apply(WebElement element) {
                return element != null && attributeValue.equals(element.getAttribute(attributeName));
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName + "=" + attributeValue;
            }
        };
    }

    public static Condition hasText(final String text) {
        return new Condition("hasText"){

            public boolean apply(WebElement element) {
                return element != null && element.getText().contains(text);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : "<" + element.getTagName() + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "got text '" + text + "'";
            }
        };
    }

    public static Condition hasOptions() {
        return new Condition("hasOptions"){

            public boolean apply(WebElement element) {
                try {
                    return element != null && element.getText().length() > 0;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : element.getText();
            }

            public String toString() {
                return "got any options";
            }
        };
    }

    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        String[] classNames = classes.split(" ");
        return Condition.contains(classNames, cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    public static Condition hasClass(final String cssClass) {
        return new Condition("hasClass"){

            public boolean apply(WebElement element) {
                return element != null && 6.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : "<" + element.getTagName() + " @class='" + element.getAttribute("class") + "'" + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "got class '" + cssClass + "'";
            }
        };
    }

    public static Condition hasNotClass(final String cssClass) {
        return new Condition("hasNotClass"){

            public boolean apply(WebElement element) {
                return element != null && !7.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not exist" : "<" + element.getTagName() + " @class='" + element.getAttribute("class") + "'" + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "loose class '" + cssClass + "'";
            }
        };
    }

    public Condition(String name) {
        this.name = name;
    }

    public abstract boolean apply(WebElement var1);

    public abstract String actualValue(WebElement var1);

    public String toString() {
        return "become " + this.name;
    }
}

