/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Navigation;
import com.codeborne.selenide.WebDriverRunner;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class DOM {
    private static final long defaultWaitingTimeout = Long.getLong("timeout", 4000L);

    public static WebElement getElement(By by) {
        try {
            return WebDriverRunner.getWebDriver().findElement(by);
        }
        catch (WebDriverException e) {
            return (WebElement)WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(By by, String value) {
        try {
            WebElement element = WebDriverRunner.getWebDriver().findElement(by);
            DOM.setValue(element, value);
            DOM.triggerChangeEvent(by);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(WebElement element, String value) {
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    static boolean isJQueryAvailable() {
        Object result = DOM.executeJavaScript("return (typeof jQuery);");
        return !"undefined".equalsIgnoreCase(String.valueOf(result));
    }

    public static void click(By by) {
        if (!DOM.isJQueryAvailable()) {
            DOM.getElement(by).click();
        } else {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".click();");
        }
    }

    public static void click(By by, int index) {
        List matchedElements = WebDriverRunner.getWebDriver().findElements(by);
        if (index >= matchedElements.size()) {
            throw new IllegalArgumentException("Cannot click " + index + "th element: there is only " + matchedElements.size() + " elements on the page");
        }
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".eq(" + index + ").click();");
        } else {
            ((WebElement)matchedElements.get(index)).click();
        }
    }

    public static void triggerChangeEvent(By by) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".change();");
        }
    }

    public static String getJQuerySelector(By seleniumSelector) {
        return "$(\"" + DOM.getJQuerySelectorString(seleniumSelector) + "\")";
    }

    public static String getJQuerySelectorString(By seleniumSelector) {
        if (seleniumSelector instanceof By.ByName) {
            String name = seleniumSelector.toString().replaceFirst("By\\.name:\\s*(.*)", "$1");
            return "*[name='" + name + "']";
        }
        if (seleniumSelector instanceof By.ById) {
            String id = seleniumSelector.toString().replaceFirst("By\\.id:\\s*(.*)", "$1");
            return "#" + id;
        }
        if (seleniumSelector instanceof By.ByClassName) {
            String className = seleniumSelector.toString().replaceFirst("By\\.className:\\s*(.*)", "$1");
            return "." + className;
        }
        if (seleniumSelector instanceof By.ByXPath) {
            String seleniumXPath = seleniumSelector.toString().replaceFirst("By\\.xpath:\\s*(.*)", "$1");
            return seleniumXPath.replaceFirst("\\/\\/(.*)", "$1").replaceAll("\\[@", "[");
        }
        return seleniumSelector.toString();
    }

    public static String describeElement(WebElement element) {
        return "<" + element.getTagName() + " value=" + element.getAttribute("value") + " class=" + element.getAttribute("class") + " id=" + element.getAttribute("id") + " name=" + element.getAttribute("name") + " onclick=" + element.getAttribute("onclick") + " onClick=" + element.getAttribute("onClick") + " onchange=" + element.getAttribute("onchange") + " onChange=" + element.getAttribute("onChange") + ">" + element.getText() + "</" + element.getTagName() + ">";
    }

    public static Object executeJavaScript(String jsCode) {
        return ((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, new Object[0]);
    }

    public static void scrollTo(By element) {
        if (!DOM.isJQueryAvailable()) {
            throw new IllegalStateException("JQuery is not available on current page");
        }
        DOM.executeJavaScript("$.scrollTo('" + DOM.getJQuerySelectorString(element) + "')");
    }

    public static void selectRadio(String radioFieldId, String value) {
        String radioButtonId = radioFieldId + value;
        Assert.assertThat((Object)WebDriverRunner.getWebDriver().findElements(By.id((String)radioButtonId)).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)DOM.getElement(By.id((String)radioButtonId)).isDisplayed(), (Matcher)CoreMatchers.is((Object)true));
        By byXpath = By.xpath((String)("//label[@for='" + radioButtonId + "']"));
        Assert.assertThat((Object)WebDriverRunner.getWebDriver().findElements(byXpath).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)DOM.getElement(byXpath).isDisplayed(), (Matcher)CoreMatchers.is((Object)true));
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(By.id((String)radioButtonId)) + ".attr('checked', true);");
            DOM.sleep(100L);
            DOM.executeJavaScript(DOM.getJQuerySelector(By.id((String)radioButtonId)) + ".click();");
            DOM.sleep(100L);
        } else {
            DOM.click(By.id((String)(radioFieldId + value)));
            DOM.triggerChangeEvent(By.id((String)radioFieldId));
        }
    }

    public static String getSelectedValue(By selectField) {
        WebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getAttribute("value");
    }

    public static String getSelectedText(By selectField) {
        WebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getText();
    }

    private static WebElement findSelectedOption(By selectField) {
        WebElement selectElement = DOM.getElement(selectField);
        List options = selectElement.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (option.getAttribute("selected") == null) continue;
            return option;
        }
        return null;
    }

    public static void selectOption(By selectField, String value) {
        DOM.waitFor(selectField, Condition.hasOptions());
        DOM.findOptionByValue(selectField, value).click();
        DOM.triggerChangeEvent(selectField);
    }

    private static WebElement findOptionByValue(By selectField, String value) {
        try {
            WebElement selectElement = DOM.getElement(selectField);
            List options = selectElement.findElements(By.tagName((String)"option"));
            for (WebElement option : options) {
                if (!option.getAttribute("value").equals(value)) continue;
                return option;
            }
        }
        catch (WebDriverException e) {
            throw new IllegalArgumentException("Option " + value + " is not found for select " + selectField, e);
        }
        throw new IllegalArgumentException("Option " + value + " is not found for select " + selectField);
    }

    public static void selectOptionByText(By selectField, String value) {
        DOM.waitFor(selectField, Condition.hasOptions());
        DOM.findOptionByText(selectField, value).click();
        DOM.triggerChangeEvent(selectField);
    }

    private static WebElement findOptionByText(By selectField, String text) {
        WebElement selectElement = DOM.getElement(selectField);
        try {
            return selectElement.findElement(By.xpath((String)("option[text()='" + text + "']")));
        }
        catch (WebDriverException e) {
            throw new IllegalArgumentException("Option " + text + " is not found for select " + selectField, e);
        }
    }

    @Deprecated
    public static boolean existsAndVisible(By logoutLink) {
        try {
            return WebDriverRunner.getWebDriver().findElement(logoutLink).isDisplayed();
        }
        catch (NoSuchElementException doesNotExist) {
            return false;
        }
    }

    public static void followLink(By by) {
        WebElement link = DOM.getElement(by);
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Navigation.navigateToAbsoluteUrl(href);
        }
    }

    private static String getActualValue(WebElement element, Condition condition) {
        try {
            return condition.actualValue(element);
        }
        catch (WebDriverException e) {
            return e.toString();
        }
    }

    public static boolean isVisible(By selector) {
        return DOM.getElement(selector).isDisplayed();
    }

    public static WebElement assertVisible(By selector) {
        return DOM.assertElement(selector, Condition.visible);
    }

    public static WebElement assertHidden(By selector) {
        return DOM.assertElement(selector, Condition.hidden);
    }

    public static WebElement assertElement(By selector, Condition condition) {
        WebElement element = DOM.getElement(selector);
        if (!condition.apply(element)) {
            WebDriverRunner.fail("Element " + selector + " hasn't " + condition + "; actual value is '" + DOM.getActualValue(element, condition) + "'");
        }
        return element;
    }

    public static WebElement waitFor(By by) {
        return DOM.waitFor(by, Condition.visible);
    }

    public static WebElement waitFor(By by, Condition condition) {
        return DOM.waitFor(by, condition, defaultWaitingTimeout);
    }

    public static WebElement waitFor(By by, Condition condition, long milliseconds) {
        long startTime = System.currentTimeMillis();
        WebElement element = null;
        do {
            try {
                element = WebDriverRunner.getWebDriver().findElement(by);
                if (condition.apply(element)) {
                    return element;
                }
            }
            catch (WebDriverException ignored) {
                // empty catch block
            }
            DOM.sleep(50L);
        } while (System.currentTimeMillis() - startTime < milliseconds);
        WebDriverRunner.fail("Element " + by + " hasn't " + condition + " in " + milliseconds + " ms.; actual value is '" + DOM.getActualValue(element, condition) + "'");
        return null;
    }

    private static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

