/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebDriverRunner;
import org.junit.Assert;
import org.openqa.selenium.By;

public class Navigation {
    public static String baseUrl = "http://localhost:8080";

    public static void open(String relativeUrl) {
        Navigation.navigateToAbsoluteUrl(baseUrl + relativeUrl);
    }

    public static void navigateToAbsoluteUrl(String url) {
        WebDriverRunner.getWebDriver().navigate().to(Navigation.makeUniqueUrl(url, System.nanoTime()));
        Assert.assertTrue((boolean)WebDriverRunner.getWebDriver().findElement(By.tagName((String)"body")).isDisplayed());
        if (WebDriverRunner.ie()) {
            Navigation.toBeSureThatPageIsNotCached();
        }
    }

    private static void toBeSureThatPageIsNotCached() {
        String currentUrl = WebDriverRunner.getWebDriver().getCurrentUrl();
        if (!currentUrl.contains("timestamp=")) {
            Navigation.navigateToAbsoluteUrl(currentUrl);
        }
    }

    static String makeUniqueUrl(String url, long unique) {
        String fullUrl = url.contains("timestamp=") ? url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique) : (url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique);
        return fullUrl;
    }
}

