/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class DOM
extends Selenide {
    @Deprecated
    public static void setValue(By by, String value) {
        try {
            ShouldableWebElement element = DOM.$(by);
            DOM.setValue(element, value);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + WebDriverRunner.cleanupWebDriverExceptionMessage(e));
        }
    }

    @Deprecated
    public static void setValue(By by, int index, String value) {
        try {
            ShouldableWebElement element = DOM.$(by, index);
            DOM.setValue(element, value);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + " and index " + index + ", caused by: " + WebDriverRunner.cleanupWebDriverExceptionMessage(e));
        }
    }

    public static void setValue(WebElement element, String value) {
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    public static boolean isJQueryAvailable() {
        Object result = DOM.executeJavaScript("return (typeof jQuery);");
        return !"undefined".equalsIgnoreCase(String.valueOf(result));
    }

    public static void click(By by) {
        DOM.$(by).click();
    }

    public static void callOnClick(By by) {
        DOM.executeJavaScript("eval(\"" + DOM.$(by).getAttribute("onclick") + "\")");
    }

    @Deprecated
    public static void click(By by, int index) {
        List matchedElements = WebDriverRunner.getWebDriver().findElements(by);
        if (index < 0 || index >= matchedElements.size()) {
            throw new IllegalArgumentException("Cannot click " + index + "th element: there is " + matchedElements.size() + " elements on the page");
        }
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "eq(" + index + ").click();");
        } else {
            ((WebElement)matchedElements.get(index)).click();
        }
    }

    @Deprecated
    public static void triggerChangeEvent(By by) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "change()");
        }
    }

    @Deprecated
    public static void triggerChangeEvent(By by, int index) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "eq(" + index + ").change()");
        }
    }

    @Deprecated
    public static void executeJQueryMethod(By by, String method) {
        String selector = DOM.getJQuerySelector(by);
        if (selector != null) {
            DOM.executeJavaScript("$(\"" + selector + "\")." + method);
        } else {
            System.err.println("Warning: can't convert " + by + " to JQuery selector, unable to execute " + method);
        }
    }

    @Deprecated
    private static String getJQuerySelector(By seleniumSelector) {
        if (seleniumSelector instanceof By.ByName) {
            String name = seleniumSelector.toString().replaceFirst("By\\.name:\\s*(.*)", "$1");
            return "[name='" + name + "']";
        }
        if (seleniumSelector instanceof By.ById) {
            String id = seleniumSelector.toString().replaceFirst("By\\.id:\\s*(.*)", "$1");
            return "#" + id;
        }
        if (seleniumSelector instanceof By.ByClassName) {
            String className = seleniumSelector.toString().replaceFirst("By\\.className:\\s*(.*)", "$1");
            return "." + className;
        }
        if (seleniumSelector instanceof By.ByCssSelector) {
            return seleniumSelector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1");
        }
        if (seleniumSelector instanceof By.ByXPath) {
            String seleniumXPath = seleniumSelector.toString().replaceFirst("By\\.xpath:\\s*(.*)", "$1");
            return seleniumXPath.replaceFirst("//(.*)", "$1").replaceAll("\\[@", "[");
        }
        return null;
    }

    @Deprecated
    public static void scrollTo(By element) {
        if (!DOM.isJQueryAvailable()) {
            throw new IllegalStateException("JQuery is not available on current page");
        }
        DOM.executeJavaScript("$.scrollTo('" + DOM.getJQuerySelector(element) + "')");
    }

    public static String getSelectedValue(By selectField) {
        return DOM.$(selectField).getSelectedValue();
    }

    public static String getSelectedText(By selectField) {
        return DOM.$(selectField).getSelectedText();
    }

    public static Select select(By selectField) {
        return new Select((WebElement)DOM.$(selectField));
    }

    public static void selectOption(By selectField, String value) {
        DOM.select(selectField).selectByValue(value);
    }

    public static void selectOptionByText(By selectField, String text) {
        DOM.select(selectField).selectByVisibleText(text);
    }

    public static boolean existsAndVisible(By selector) {
        try {
            return WebDriverRunner.getWebDriver().findElement(selector).isDisplayed();
        }
        catch (NoSuchElementException doesNotExist) {
            return false;
        }
    }

    @Deprecated
    public static void followLink(By selector) {
        DOM.$(selector).followLink();
    }

    @Deprecated
    public static ShouldableWebElement assertChecked(By criteria) {
        ShouldableWebElement element = DOM.$(criteria);
        if (!"true".equalsIgnoreCase(element.getAttribute("checked"))) {
            throw new AssertionError((Object)("Element is not checked: " + element));
        }
        return element;
    }

    @Deprecated
    public static ShouldableWebElement assertNotChecked(By criteria) {
        ShouldableWebElement element = DOM.$(criteria);
        if (element.getAttribute("checked") != null) {
            throw new AssertionError((Object)("Element is checked: " + element));
        }
        return element;
    }

    @Deprecated
    public static ShouldableWebElement assertDisabled(By selector) {
        return DOM.$(selector).shouldBe(Condition.disabled);
    }

    @Deprecated
    public static ShouldableWebElement assertEnabled(By selector) {
        return DOM.$(selector).shouldBe(Condition.enabled);
    }

    @Deprecated
    public static ShouldableWebElement assertSelected(By selector) {
        return DOM.$(selector).shouldBe(Condition.selected);
    }

    @Deprecated
    public static ShouldableWebElement assertNotSelected(By selector) {
        return DOM.$(selector).shouldNotBe(Condition.selected);
    }

    @Deprecated
    public static boolean isVisible(By selector) {
        return DOM.$(selector).isDisplayed();
    }

    @Deprecated
    public static ShouldableWebElement assertVisible(By selector) {
        return DOM.assertElement(selector, Condition.visible);
    }

    @Deprecated
    public static ShouldableWebElement assertHidden(By selector) {
        return DOM.$(selector).shouldBe(Condition.hidden);
    }

    public static ShouldableWebElement assertElement(By selector, Condition condition) {
        return DOM.$(selector).should(condition);
    }

    public static ShouldableWebElement assertElement(WebElement element, Condition condition) {
        return DOM.$(element).should(condition);
    }

    public static ShouldableWebElement waitFor(By elementSelector) {
        return DOM.$(elementSelector).shouldBe(Condition.visible);
    }

    public static ShouldableWebElement waitFor(String cssSelector) {
        return DOM.$(cssSelector).shouldBe(Condition.visible);
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, Condition condition) {
        return DOM.waitUntil(elementSelector, condition);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, Condition condition) {
        return DOM.$(elementSelector).shouldBe(condition);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, Condition condition) {
        return DOM.$(cssSelector).shouldBe(condition);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, int index, Condition condition) {
        return DOM.$(elementSelector, index).shouldBe(condition);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, int index, Condition condition) {
        return DOM.$(cssSelector, index).shouldBe(condition);
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, Condition condition, long timeoutMs) {
        return DOM.$(elementSelector).waitUntil(condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, Condition condition, long timeoutMs) {
        return DOM.$(elementSelector).waitUntil(condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, Condition condition, long timeoutMs) {
        return DOM.$(cssSelector).waitUntil(condition, timeoutMs);
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, int index, Condition condition, long timeoutMs) {
        return DOM.$(elementSelector, index).waitUntil(condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, int index, Condition condition, long timeoutMs) {
        return DOM.$(cssSelector, index).waitUntil(condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, int index, Condition condition, long timeoutMs) {
        return DOM.$(elementSelector, index).waitUntil(condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(WebElement parent, By elementSelector, int index, Condition condition) {
        return DOM.$(parent, elementSelector, index).shouldBe(condition);
    }

    public static ShouldableWebElement waitUntil(WebElement parent, By elementSelector, int index, Condition condition, long timeoutMs) {
        return DOM.$(parent, elementSelector, index).waitUntil(condition, timeoutMs);
    }

    @Deprecated
    public static String describeElement(WebElement element) {
        return Describe.describe(element);
    }
}

