/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import org.openqa.selenium.By;

public class Selectors {
    public static By withText(String elementText) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(elementText);
        return elementText.contains("'") ? By.xpath((String)(".//*[contains(normalize-space(text()), \"" + elementText + "\")]")) : By.xpath((String)(".//*[contains(normalize-space(text()), '" + elementText + "')]"));
    }

    public static By byText(String elementText) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(elementText);
        return elementText.contains("'") ? By.xpath((String)(".//*[normalize-space(text()) = \"" + elementText + "\"]")) : By.xpath((String)(".//*[normalize-space(text()) = '" + elementText + "']"));
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(attributeValue);
        return attributeValue.contains("'") ? By.xpath((String)(".//*[@" + attributeName + " = \"" + attributeValue + "\"]")) : By.xpath((String)(".//*[@" + attributeName + " = '" + attributeValue + "']"));
    }

    private static void assertDoesNotContainBothApostrophesAndQuotes(String elementText) {
        if (elementText.contains("'") && elementText.contains("\"")) {
            throw new UnsupportedOperationException("Text with both apostrophes and quotes is not supported");
        }
    }
}

