/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.impl.ElementLocatorProxy;
import com.codeborne.selenide.impl.ShouldableWebElementListProxy;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedFieldDecorator
extends DefaultFieldDecorator {
    public ExtendedFieldDecorator(SearchContext searchContext) {
        super((ElementLocatorFactory)new DefaultElementLocatorFactory(searchContext));
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (ShouldableWebElement.class.isAssignableFrom(field.getType())) {
            return ElementLocatorProxy.wrap(this.factory.createLocator(field));
        }
        if (ElementsContainer.class.isAssignableFrom(field.getType())) {
            return this.createElementsContainer(field);
        }
        if (this.isDecoratableList(field, ElementsContainer.class)) {
            return this.createElementsContainerList(field);
        }
        if (this.isDecoratableList(field, ShouldableWebElement.class)) {
            return ShouldableWebElementListProxy.wrap(this.factory.createLocator(field));
        }
        return super.decorate(loader, field);
    }

    private List<ElementsContainer> createElementsContainerList(Field field) {
        try {
            ArrayList<ElementsContainer> result = new ArrayList<ElementsContainer>();
            Class<?> listType = this.getListGenericType(field);
            List<ShouldableWebElement> selfList = ShouldableWebElementListProxy.wrap(this.factory.createLocator(field));
            for (ShouldableWebElement element : selfList) {
                result.add(this.initElementsContainer(listType, element));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elements container list for field " + field.getName(), e);
        }
    }

    private ElementsContainer createElementsContainer(Field field) {
        try {
            ShouldableWebElement self = ElementLocatorProxy.wrap(this.factory.createLocator(field));
            ElementsContainer result = this.initElementsContainer(field.getType(), self);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    private ElementsContainer initElementsContainer(Class<?> type, ShouldableWebElement self) throws InstantiationException, IllegalAccessException {
        ElementsContainer result = (ElementsContainer)type.newInstance();
        PageFactory.initElements((FieldDecorator)new ExtendedFieldDecorator((SearchContext)self), (Object)result);
        result.setSelf(self);
        return result;
    }

    private boolean isDecoratableList(Field field, Class<?> type) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class<?> listType = this.getListGenericType(field);
        if (listType == null || !type.isAssignableFrom(listType)) {
            return false;
        }
        return field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null;
    }

    private Class<?> getListGenericType(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }
}

