/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.AbstractShouldableWebElementProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WebElementWaitingProxy
extends AbstractShouldableWebElementProxy {
    private final WebElement parent;
    private final By criteria;
    private final int index;

    public static ShouldableWebElement wrap(WebElement parent, By criteria, int index) {
        return (ShouldableWebElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ShouldableWebElement.class}, (InvocationHandler)new WebElementWaitingProxy(parent, criteria, index));
    }

    WebElementWaitingProxy(WebElement parent, By criteria, int index) {
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    protected WebElement getDelegate() {
        return this.waitUntil(Condition.exist, Selenide.defaultWaitingTimeout);
    }

    protected ShouldableWebElement find(Object arg, int index) {
        return arg instanceof By ? WebElementWaitingProxy.wrap(this.getDelegate(), (By)arg, index) : WebElementWaitingProxy.wrap(this.getDelegate(), By.cssSelector((String)((String)arg)), index);
    }

    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? this.getSearchContext().findElement(this.criteria) : (WebElement)this.getSearchContext().findElements(this.criteria).get(this.index);
    }

    private SearchContext getSearchContext() {
        return this.parent == null ? WebDriverRunner.getWebDriver() : this.parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.criteria + (this.parent == null ? "" : ", in: " + this.parent) + (this.index == 0 ? "" : ", index: " + this.index) + '}';
    }
}

