/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.impl.Describe;
import java.util.regex.Pattern;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Condition {
    public static final Condition visible = new Condition("visible", false){

        public boolean apply(WebElement element) {
            return element != null && element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exist" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    public static final Condition present;
    public static final Condition exist;
    public static final Condition notPresent;
    public static final Condition hidden;
    public static final Condition appear;
    public static final Condition appears;
    public static final Condition disappears;
    public static final Condition disappear;
    public static final Condition readonly;
    public static final Condition empty;
    public static Condition options;
    public static final Condition focused;
    public static final Condition enabled;
    public static final Condition disabled;
    @Deprecated
    public static final Condition checked;
    public static final Condition selected;
    private final String name;
    private final boolean nullIsAllowed;

    public static Condition hasAttribute(String attributeName, String attributeValue) {
        return Condition.attribute(attributeName, attributeValue);
    }

    public static Condition attribute(final String attributeName) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return element != null && element.getAttribute(attributeName) != null;
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName;
            }
        };
    }

    public static Condition attribute(final String attributeName, final String expectedAttributeValue) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return element != null && expectedAttributeValue.equals(Condition.getAttributeValue(element, attributeName));
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName + "=" + expectedAttributeValue;
            }
        };
    }

    private static String getAttributeValue(WebElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        return attr == null ? "" : attr.trim();
    }

    public static Condition value(String value) {
        return Condition.hasAttribute("value", value);
    }

    public static Condition hasValue(String value) {
        return Condition.value(value);
    }

    public static Condition matchesText(String text) {
        return Condition.matchText(text);
    }

    public static Condition matchText(final String regex) {
        return new Condition("match", false){

            public boolean apply(WebElement element) {
                return element != null && Condition.matches(element.getText(), regex);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "matched text '" + regex + "'";
            }
        };
    }

    private static boolean matches(String text, String regex) {
        return Pattern.compile(".*" + regex + ".*", 32).matcher(text).matches();
    }

    public static Condition hasText(String text) {
        return Condition.text(text);
    }

    @Deprecated
    public static Condition haveText(String text) {
        return Condition.hasText(text);
    }

    public static Condition text(final String text) {
        return new Condition("text", false){

            public boolean apply(WebElement element) {
                return element != null && element.getText().contains(text);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "got text '" + text + "'";
            }
        };
    }

    public static Condition exactText(final String text) {
        return new Condition("exactText", false){

            public boolean apply(WebElement element) {
                return element != null && text.equals(element.getText());
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "got exactly the text '" + text + "'";
            }
        };
    }

    public static Condition hasOptions() {
        return options;
    }

    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        return classes == null ? false : Condition.contains(classes.split(" "), cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    public static Condition cssClass(String cssClass) {
        return Condition.hasClass(cssClass);
    }

    public static Condition hasClass(final String cssClass) {
        return new Condition("hasClass", false){

            public boolean apply(WebElement element) {
                return element != null && 12.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "got class '" + cssClass + "'";
            }
        };
    }

    public static Condition hasNotClass(final String cssClass) {
        return new Condition("hasNotClass", false){

            public boolean apply(WebElement element) {
                return element != null && !13.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "loose class '" + cssClass + "'";
            }
        };
    }

    public Condition(String name, boolean nullIsAllowed) {
        this.name = name;
        this.nullIsAllowed = nullIsAllowed;
    }

    public abstract boolean apply(WebElement var1);

    public final boolean applyNull() {
        return this.nullIsAllowed;
    }

    public abstract String actualValue(WebElement var1);

    public String toString() {
        return "become " + this.name;
    }

    static {
        exist = present = new Condition("present", false){

            public boolean apply(WebElement element) {
                return true;
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "exists";
            }
        };
        notPresent = new Condition("notPresent", true){

            public boolean apply(WebElement element) {
                return element == null;
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "exists";
            }
        };
        hidden = new Condition("hidden", true){

            public boolean apply(WebElement element) {
                try {
                    return element == null || !element.isDisplayed();
                }
                catch (StaleElementReferenceException elementHasDisappeared) {
                    return true;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
            }
        };
        appear = visible;
        appears = visible;
        disappears = hidden;
        disappear = hidden;
        readonly = Condition.attribute("readonly");
        empty = new Condition("empty", false){
            private final Condition emptyValue = 7.value("");
            private final Condition emptyText = 7.exactText("");

            public boolean apply(WebElement element) {
                return this.emptyValue.apply(element) && this.emptyText.apply(element);
            }

            public String actualValue(WebElement element) {
                return "value=" + Condition.getAttributeValue(element, "value") + ", text='" + element.getText() + "'";
            }
        };
        options = new Condition("hasOptions", false){

            public boolean apply(WebElement element) {
                try {
                    return element != null && element.getText().length() > 0;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "got any options";
            }
        };
        focused = new Condition("focused", false){

            public boolean apply(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement != null && focusedElement.equals(webElement);
            }

            public String actualValue(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement == null ? "No focused focusedElement found " : "Focused focusedElement: " + Describe.describe(focusedElement) + ", current focusedElement: " + Describe.describe(webElement);
            }
        };
        enabled = new Condition("enabled", false){

            public boolean apply(WebElement element) {
                return element != null && element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : (element.isEnabled() ? "enabled" : "disabled");
            }
        };
        disabled = new Condition("disabled", false){

            public boolean apply(WebElement element) {
                return element != null && !element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : (element.isEnabled() ? "enabled" : "disabled");
            }
        };
        checked = new Condition("checked", false){

            public boolean apply(WebElement element) {
                return element != null && "true".equalsIgnoreCase(element.getAttribute("checked"));
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getAttribute("checked");
            }
        };
        selected = new Condition("selected", false){

            public boolean apply(WebElement element) {
                return element != null && element.isSelected();
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : String.valueOf(element.isSelected());
            }
        };
    }
}

