/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Selenide;
import org.openqa.selenium.By;

public class JQuery {
    public void onClick(By by) {
        Selenide.executeJavaScript("eval(\"" + Selenide.$(by).getAttribute("onclick") + "\")");
    }

    public void change(By by) {
        if (this.isJQueryAvailable()) {
            this.executeJQueryMethod(by, "change()");
        }
    }

    public void change(By by, int index) {
        if (this.isJQueryAvailable()) {
            this.executeJQueryMethod(by, "eq(" + index + ").change()");
        }
    }

    public void scrollTo(By element) {
        if (!this.isJQueryAvailable()) {
            throw new IllegalStateException("JQuery is not available on current page");
        }
        Selenide.executeJavaScript("$.scrollTo('" + this.getJQuerySelector(element) + "')");
    }

    public void executeJQueryMethod(By by, String method) {
        String selector = this.getJQuerySelector(by);
        if (selector != null) {
            Selenide.executeJavaScript("$(\"" + selector + "\")." + method);
        } else {
            System.err.println("Warning: can't convert " + by + " to JQuery selector, unable to execute " + method);
        }
    }

    public boolean isJQueryAvailable() {
        Object result = Selenide.executeJavaScript("return (typeof jQuery);");
        return !"undefined".equalsIgnoreCase(String.valueOf(result));
    }

    protected String getJQuerySelector(By seleniumSelector) {
        if (seleniumSelector instanceof By.ByName) {
            String name = seleniumSelector.toString().replaceFirst("By\\.name:\\s*(.*)", "$1");
            return "*[name='" + name + "']";
        }
        if (seleniumSelector instanceof By.ById) {
            String id = seleniumSelector.toString().replaceFirst("By\\.id:\\s*(.*)", "$1");
            return "#" + id;
        }
        if (seleniumSelector instanceof By.ByClassName) {
            String className = seleniumSelector.toString().replaceFirst("By\\.className:\\s*(.*)", "$1");
            return "." + className;
        }
        if (seleniumSelector instanceof By.ByCssSelector) {
            return seleniumSelector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1");
        }
        if (seleniumSelector instanceof By.ByXPath) {
            String seleniumXPath = seleniumSelector.toString().replaceFirst("By\\.xpath:\\s*(.*)", "$1");
            return seleniumXPath.replaceFirst("//(.*)", "$1").replaceAll("\\[@", "[");
        }
        return null;
    }
}

