/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.ExtendedFieldDecorator;
import com.codeborne.selenide.impl.Navigator;
import com.codeborne.selenide.impl.ShouldableWebElementProxy;
import com.codeborne.selenide.impl.WebElementWaitingProxy;
import java.net.URL;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selenide {
    public static long defaultWaitingTimeout = Long.parseLong(System.getProperty("timeout", "4000"));
    public static Navigator navigator = new Navigator();

    public static void open(String relativeOrAbsoluteUrl) {
        navigator.open(relativeOrAbsoluteUrl);
    }

    public static void open(URL absoluteUrl) {
        navigator.open(absoluteUrl);
    }

    public static void refresh() {
        navigator.open(WebDriverRunner.url());
    }

    public static String title() {
        return WebDriverRunner.getWebDriver().getTitle();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static ShouldableWebElement $(WebElement webElement) {
        return ShouldableWebElementProxy.wrap(webElement);
    }

    public static ShouldableWebElement $(String cssSelector) {
        return Selenide.getElement(By.cssSelector((String)cssSelector));
    }

    public static ShouldableWebElement $(By seleniumSelector) {
        return Selenide.getElement(seleniumSelector);
    }

    public static ShouldableWebElement $(By seleniumSelector, int index) {
        return Selenide.getElement(seleniumSelector, index);
    }

    public static ShouldableWebElement $(WebElement parent, String cssSelector) {
        return WebElementWaitingProxy.wrap(parent, By.cssSelector((String)cssSelector), 0);
    }

    public static ShouldableWebElement $(String cssSelector, int index) {
        return WebElementWaitingProxy.wrap(null, By.cssSelector((String)cssSelector), index);
    }

    public static ShouldableWebElement $(WebElement parent, String cssSelector, int index) {
        return WebElementWaitingProxy.wrap(parent, By.cssSelector((String)cssSelector), index);
    }

    protected static ShouldableWebElement $(WebElement parent, By selector, int index) {
        return WebElementWaitingProxy.wrap(parent, selector, index);
    }

    public static ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(Selenide.getElements(By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return new ElementsCollection(Selenide.getElements(seleniumSelector));
    }

    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return new ElementsCollection(parent.findElements(By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return new ElementsCollection(parent.findElements(seleniumSelector));
    }

    public static ShouldableWebElement getElement(By criteria) {
        return WebElementWaitingProxy.wrap(null, criteria, 0);
    }

    public static ShouldableWebElement getElement(By criteria, int index) {
        return WebElementWaitingProxy.wrap(null, criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        try {
            return new ElementsCollection(WebDriverRunner.getWebDriver().findElements(criteria));
        }
        catch (WebDriverException e) {
            return (ElementsCollection)WebDriverRunner.fail("Cannot get element " + criteria + ", caused by: " + WebDriverRunner.cleanupWebDriverExceptionMessage(e));
        }
    }

    public static Object executeJavaScript(String jsCode) {
        return ((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, new Object[0]);
    }

    public static ShouldableWebElement selectRadio(By radioField, String value) {
        Selenide.$(radioField).shouldBe(Condition.enabled);
        for (WebElement radio : Selenide.$$(radioField)) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            radio.click();
            return ShouldableWebElementProxy.wrap(radio);
        }
        throw new NoSuchElementException(radioField + " and value " + value);
    }

    public static ShouldableWebElement getSelectedRadio(By radioField) {
        for (WebElement radio : Selenide.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return ShouldableWebElementProxy.wrap(radio);
        }
        return null;
    }

    private static String getActualValue(WebElement element, Condition condition) {
        try {
            return condition.actualValue(element);
        }
        catch (WebDriverException e) {
            return WebDriverRunner.cleanupWebDriverExceptionMessage(e);
        }
    }

    public static void confirm(String expectedConfirmationText) {
        try {
            Alert alert = Selenide.checkAlertMessage(expectedConfirmationText);
            alert.accept();
        }
        catch (UnsupportedOperationException alertIsNotSupportedInHtmlUnit) {
            return;
        }
        Selenide.waitUntilAlertDisappears();
    }

    public static void dismiss(String expectedConfirmationText) {
        try {
            Alert alert = Selenide.checkAlertMessage(expectedConfirmationText);
            alert.dismiss();
        }
        catch (UnsupportedOperationException alertIsNotSupportedInHtmlUnit) {
            return;
        }
        Selenide.waitUntilAlertDisappears();
    }

    private static Alert checkAlertMessage(String expectedConfirmationText) {
        Alert alert = WebDriverRunner.getWebDriver().switchTo().alert();
        if (expectedConfirmationText != null && !expectedConfirmationText.equals(alert.getText())) {
            throw new AssertionError((Object)("Actual confirmation text is '" + alert.getText() + "', but expected: '" + expectedConfirmationText + "'"));
        }
        return alert;
    }

    private static void waitUntilAlertDisappears() {
        try {
            long start = System.currentTimeMillis();
            while (WebDriverRunner.getWebDriver().switchTo().alert() != null) {
                WebDriverRunner.getWebDriver().switchTo().alert();
                if (System.currentTimeMillis() - start > defaultWaitingTimeout) {
                    WebDriverRunner.fail("Confirmation dialog has not disappeared in " + defaultWaitingTimeout + " milliseconds");
                }
                Selenide.sleep(100L);
            }
        }
        catch (NoAlertPresentException noAlertPresentException) {
            // empty catch block
        }
    }

    public static WebDriver.TargetLocator switchTo() {
        return WebDriverRunner.getWebDriver().switchTo();
    }

    public static WebElement getFocusedElement() {
        return (WebElement)Selenide.executeJavaScript("return document.activeElement");
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        try {
            return Selenide.page(pageObjectClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        PageFactory.initElements((FieldDecorator)new ExtendedFieldDecorator((SearchContext)WebDriverRunner.getWebDriver()), pageObject);
        return pageObject;
    }
}

