/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Navigation;
import com.codeborne.selenide.WebDriverRunner;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM {
    private static final long defaultWaitingTimeout = Long.getLong("timeout", 4000L);

    public static WebElement getElement(By by) {
        try {
            return WebDriverRunner.getWebDriver().findElement(by);
        }
        catch (WebDriverException e) {
            return (WebElement)WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static WebElement getElement(By by, int index) {
        try {
            return (WebElement)WebDriverRunner.getWebDriver().findElements(by).get(index);
        }
        catch (WebDriverException e) {
            return (WebElement)WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static List<WebElement> getElements(By by) {
        try {
            return WebDriverRunner.getWebDriver().findElements(by);
        }
        catch (WebDriverException e) {
            return (List)WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(By by, String value) {
        try {
            WebElement element = DOM.getElement(by);
            DOM.setValue(element, value);
            DOM.triggerChangeEvent(by);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(By by, int index, String value) {
        try {
            WebElement element = DOM.getElement(by, index);
            DOM.setValue(element, value);
            DOM.triggerChangeEvent(by, index);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + " and index " + index + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(WebElement element, String value) {
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    public static boolean isJQueryAvailable() {
        Object result = DOM.executeJavaScript("return (typeof jQuery);");
        return !"undefined".equalsIgnoreCase(String.valueOf(result));
    }

    public static void click(By by) {
        DOM.getElement(by).click();
    }

    public static void click(By by, int index) {
        List matchedElements = WebDriverRunner.getWebDriver().findElements(by);
        if (index >= matchedElements.size()) {
            throw new IllegalArgumentException("Cannot click " + index + "th element: there is only " + matchedElements.size() + " elements on the page");
        }
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".eq(" + index + ").click();");
        } else {
            ((WebElement)matchedElements.get(index)).click();
        }
    }

    public static void triggerChangeEvent(By by) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".change();");
        }
    }

    public static void triggerChangeEvent(By by, int index) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJavaScript(DOM.getJQuerySelector(by) + ".eq(" + index + ").change();");
        }
    }

    public static String getJQuerySelector(By seleniumSelector) {
        return "$(\"" + DOM.getJQuerySelectorString(seleniumSelector) + "\")";
    }

    public static String getJQuerySelectorString(By seleniumSelector) {
        if (seleniumSelector instanceof By.ByName) {
            String name = seleniumSelector.toString().replaceFirst("By\\.name:\\s*(.*)", "$1");
            return "*[name='" + name + "']";
        }
        if (seleniumSelector instanceof By.ById) {
            String id = seleniumSelector.toString().replaceFirst("By\\.id:\\s*(.*)", "$1");
            return "#" + id;
        }
        if (seleniumSelector instanceof By.ByClassName) {
            String className = seleniumSelector.toString().replaceFirst("By\\.className:\\s*(.*)", "$1");
            return "." + className;
        }
        if (seleniumSelector instanceof By.ByXPath) {
            String seleniumXPath = seleniumSelector.toString().replaceFirst("By\\.xpath:\\s*(.*)", "$1");
            return seleniumXPath.replaceFirst("\\/\\/(.*)", "$1").replaceAll("\\[@", "[");
        }
        return seleniumSelector.toString();
    }

    public static String describeElement(WebElement element) {
        return "<" + element.getTagName() + " value=" + element.getAttribute("value") + " class=" + element.getAttribute("class") + " id=" + element.getAttribute("id") + " name=" + element.getAttribute("name") + " onclick=" + element.getAttribute("onclick") + " onClick=" + element.getAttribute("onClick") + " onchange=" + element.getAttribute("onchange") + " onChange=" + element.getAttribute("onChange") + ">" + element.getText() + "</" + element.getTagName() + ">";
    }

    public static Object executeJavaScript(String jsCode) {
        return ((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, new Object[0]);
    }

    public static void scrollTo(By element) {
        if (!DOM.isJQueryAvailable()) {
            throw new IllegalStateException("JQuery is not available on current page");
        }
        DOM.executeJavaScript("$.scrollTo('" + DOM.getJQuerySelectorString(element) + "')");
    }

    public static WebElement selectRadio(By radioField, String value) {
        DOM.assertEnabled(radioField);
        for (WebElement radio : DOM.getElements(radioField)) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            radio.click();
            return radio;
        }
        throw new NoSuchElementException("With " + radioField);
    }

    public static String getSelectedValue(By selectField) {
        WebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getAttribute("value");
    }

    public static String getSelectedText(By selectField) {
        WebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getText();
    }

    private static WebElement findSelectedOption(By selectField) {
        WebElement selectElement = DOM.getElement(selectField);
        List options = selectElement.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (option.getAttribute("selected") == null) continue;
            return option;
        }
        return null;
    }

    public static Select select(By selectField) {
        return new Select(DOM.getElement(selectField));
    }

    public static void selectOption(By selectField, String value) {
        DOM.select(selectField).selectByValue(value);
    }

    public static void selectOptionByText(By selectField, String text) {
        DOM.select(selectField).selectByVisibleText(text);
    }

    public static boolean existsAndVisible(By logoutLink) {
        try {
            return WebDriverRunner.getWebDriver().findElement(logoutLink).isDisplayed();
        }
        catch (NoSuchElementException doesNotExist) {
            return false;
        }
    }

    public static void followLink(By by) {
        WebElement link = DOM.getElement(by);
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Navigation.navigateToAbsoluteUrl(href);
        }
    }

    private static String getActualValue(WebElement element, Condition condition) {
        try {
            return condition.actualValue(element);
        }
        catch (WebDriverException e) {
            return e.toString();
        }
    }

    public static void assertChecked(By element) {
        Assert.assertThat((Object)DOM.getElement(element).getAttribute("checked"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    public static void assertNotChecked(By element) {
        Assert.assertNull((Object)DOM.getElement(element).getAttribute("checked"));
    }

    public static void assertDisabled(By element) {
        Assert.assertThat((Object)DOM.getElement(element).getAttribute("disabled"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    public static void assertEnabled(By element) {
        Assert.assertThat((Object)DOM.getElement(element).getAttribute("disabled"), (Matcher)CoreMatchers.equalTo((Object)"false"));
    }

    public static void assertSelected(By element) {
        Assert.assertTrue((boolean)DOM.getElement(element).isSelected());
    }

    public static void assertNotSelected(By element) {
        Assert.assertFalse((boolean)DOM.getElement(element).isSelected());
    }

    public static boolean isVisible(By selector) {
        return DOM.getElement(selector).isDisplayed();
    }

    public static WebElement assertVisible(By selector) {
        return DOM.assertElement(selector, Condition.visible);
    }

    public static WebElement assertHidden(By selector) {
        return DOM.assertElement(selector, Condition.hidden);
    }

    public static WebElement assertElement(By selector, Condition condition) {
        WebElement element = DOM.getElement(selector);
        if (!condition.apply(element)) {
            WebDriverRunner.fail("Element " + selector + " hasn't " + condition + "; actual value is '" + DOM.getActualValue(element, condition) + "'");
        }
        return element;
    }

    public static WebElement waitFor(By elementSelector) {
        return DOM.waitUntil(elementSelector, 0, Condition.visible, defaultWaitingTimeout);
    }

    @Deprecated
    public static WebElement waitFor(By elementSelector, Condition condition) {
        return DOM.waitUntil(elementSelector, condition);
    }

    public static WebElement waitUntil(By elementSelector, Condition condition) {
        return DOM.waitUntil(elementSelector, 0, condition, defaultWaitingTimeout);
    }

    public static WebElement waitUntil(By elementSelector, int index, Condition condition) {
        return DOM.waitUntil(elementSelector, index, condition, defaultWaitingTimeout);
    }

    @Deprecated
    public static WebElement waitFor(By elementSelector, Condition condition, long milliseconds) {
        return DOM.waitUntil(elementSelector, condition, milliseconds);
    }

    public static WebElement waitUntil(By elementSelector, Condition condition, long milliseconds) {
        return DOM.waitUntil(elementSelector, 0, condition, milliseconds);
    }

    @Deprecated
    public static WebElement waitFor(By elementSelector, int index, Condition condition, long milliseconds) {
        return DOM.waitUntil(elementSelector, index, condition, milliseconds);
    }

    public static WebElement waitUntil(By elementSelector, int index, Condition condition, long milliseconds) {
        long startTime = System.currentTimeMillis();
        WebElement element = null;
        do {
            try {
                element = index == 0 ? WebDriverRunner.getWebDriver().findElement(elementSelector) : (WebElement)WebDriverRunner.getWebDriver().findElements(elementSelector).get(index);
                if (condition.apply(element)) {
                    return element;
                }
            }
            catch (WebDriverException ignored) {
                // empty catch block
            }
            Navigation.sleep(50L);
        } while (System.currentTimeMillis() - startTime < milliseconds);
        WebDriverRunner.fail("Element " + elementSelector + " hasn't " + condition + " in " + milliseconds + " ms.; actual value is '" + DOM.getActualValue(element, condition) + "'");
        return null;
    }
}

