/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebDriverRunner;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Condition {
    public static final Condition visible = new Condition("visible", false){

        public boolean apply(WebElement element) {
            return element != null && element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    public static final Condition hidden = new Condition("hidden", true){

        public boolean apply(WebElement element) {
            return element == null || !element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    public static final Condition appears = visible;
    public static final Condition disappears = hidden;
    public static final Condition empty = Condition.hasValue("");
    public static final Condition focused = new Condition("focused", false){

        public boolean apply(WebElement webElement) {
            return webElement.getAttribute("name").equals(WebDriverRunner.getWebDriver().findElement(By.cssSelector((String)":focus")).getAttribute("name"));
        }

        public String actualValue(WebElement webElement) {
            return WebDriverRunner.getWebDriver().findElement(By.cssSelector((String)":focus")).getAttribute("name");
        }
    };
    public static final Condition enabled = new Condition("enabled", false){

        public boolean apply(WebElement element) {
            return element != null && element.isEnabled();
        }

        public String actualValue(WebElement element) {
            return element.isEnabled() ? "enabled" : "disabled";
        }
    };
    public static final Condition disabled = new Condition("disabled", false){

        public boolean apply(WebElement element) {
            return element != null && !element.isEnabled();
        }

        public String actualValue(WebElement element) {
            return element.isEnabled() ? "enabled" : "disabled";
        }
    };
    public static final Condition checked = new Condition("checked", false){

        public boolean apply(WebElement element) {
            return element != null && "true".equalsIgnoreCase(element.getAttribute("checked"));
        }

        public String actualValue(WebElement element) {
            return element.isEnabled() ? "enabled" : "disabled";
        }
    };
    private final String name;
    private final boolean nullIsAllowed;

    public static Condition hasAttribute(final String attributeName, final String attributeValue) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return element != null && attributeValue.equals(element.getAttribute(attributeName).trim());
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName + "=" + attributeValue;
            }
        };
    }

    public static Condition hasValue(String value) {
        return Condition.hasAttribute("value", value);
    }

    public static Condition hasText(final String text) {
        return new Condition("hasText", false){

            public boolean apply(WebElement element) {
                return element != null && element.getText().contains(text);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : "<" + element.getTagName() + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "got text '" + text + "'";
            }
        };
    }

    public static Condition haveText(String text) {
        return Condition.hasText(text);
    }

    public static Condition hasOptions() {
        return new Condition("hasOptions", false){

            public boolean apply(WebElement element) {
                try {
                    return element != null && element.getText().length() > 0;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : element.getText();
            }

            public String toString() {
                return "got any options";
            }
        };
    }

    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        String[] classNames = classes.split(" ");
        return Condition.contains(classNames, cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    public static Condition hasClass(final String cssClass) {
        return new Condition("hasClass", false){

            public boolean apply(WebElement element) {
                return element != null && 6.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not even exist" : "<" + element.getTagName() + " @class='" + element.getAttribute("class") + "'" + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "got class '" + cssClass + "'";
            }
        };
    }

    public static Condition hasNotClass(final String cssClass) {
        return new Condition("hasNotClass", false){

            public boolean apply(WebElement element) {
                return element != null && !7.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "element does not exist" : "<" + element.getTagName() + " @class='" + element.getAttribute("class") + "'" + ">" + element.getText() + "</" + element.getTagName() + ">";
            }

            public String toString() {
                return "loose class '" + cssClass + "'";
            }
        };
    }

    public Condition(String name, boolean nullIsAllowed) {
        this.name = name;
        this.nullIsAllowed = nullIsAllowed;
    }

    public abstract boolean apply(WebElement var1);

    public final boolean applyNull() {
        return this.nullIsAllowed;
    }

    public abstract String actualValue(WebElement var1);

    public String toString() {
        return "become " + this.name;
    }
}

