/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRunner {
    public static boolean holdBrowserOpen = Boolean.getBoolean("selenide.holdBrowserOpen");
    static String browser = System.getProperty("browser", "firefox");
    private static WebDriver webdriver;

    public static WebDriver getWebDriver() {
        if (webdriver == null) {
            webdriver = WebDriverRunner.createDriver(browser);
        }
        return webdriver;
    }

    public static void closeWebDriver() {
        if (webdriver != null) {
            if (!holdBrowserOpen) {
                webdriver.close();
            }
            webdriver = null;
        }
    }

    public static boolean ie() {
        return webdriver != null && webdriver instanceof InternetExplorerDriver;
    }

    public static void clearBrowserCache() {
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    public static String takeScreenShot(String fileName) {
        if (webdriver == null) {
            return null;
        }
        if (webdriver instanceof TakesScreenshot) {
            try {
                File scrFile = (File)((TakesScreenshot)webdriver).getScreenshotAs(OutputType.FILE);
                String pageSource = webdriver.getPageSource();
                String screenshotFileName = "build/reports/tests/" + fileName + ".png";
                String htmlFileName = "build/reports/tests/" + fileName + ".html";
                FileUtils.copyFile((File)scrFile, (File)new File(screenshotFileName));
                IOUtils.write((String)pageSource, (Writer)new FileWriter(htmlFileName));
                return screenshotFileName;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        } else {
            System.err.println("Cannot take screenshot, driver does not support it: " + webdriver);
        }
        return null;
    }

    private static WebDriver createDriver(String browser) {
        if ("chrome".equalsIgnoreCase(browser)) {
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"chrome.switches", "--start-maximized"});
            return new ChromeDriver(options);
        }
        if ("ie".equalsIgnoreCase(browser)) {
            DesiredCapabilities ieCapabilities = DesiredCapabilities.internetExplorer();
            ieCapabilities.setCapability("ignoreProtectedModeSettings", true);
            return new InternetExplorerDriver((Capabilities)ieCapabilities);
        }
        if ("htmlunit".equalsIgnoreCase(browser)) {
            DesiredCapabilities desiredCapabilities = DesiredCapabilities.htmlUnit();
            desiredCapabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
            desiredCapabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
            desiredCapabilities.setJavascriptEnabled(true);
            return new HtmlUnitDriver((Capabilities)desiredCapabilities);
        }
        return new FirefoxDriver();
    }

    static <T> T fail(String message) {
        if (webdriver == null) {
            Assert.fail((String)message);
        } else {
            Assert.fail((String)(message + ", browser.currentUrl=" + webdriver.getCurrentUrl() + ", browser.title=" + webdriver.getTitle()));
        }
        return null;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WebDriverRunner.closeWebDriver();
            }
        });
    }
}

