/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DOM;
import com.codeborne.selenide.ShouldableWebElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.openqa.selenium.WebElement;

public class ShouldableWebElementProxy
implements InvocationHandler {
    private final WebElement delegate;

    public static ShouldableWebElement wrap(WebElement element) {
        return (ShouldableWebElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{ShouldableWebElement.class}, (InvocationHandler)new ShouldableWebElementProxy(element));
    }

    private ShouldableWebElementProxy(WebElement delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("should".equals(method.getName()) || "shouldBe".equals(method.getName())) {
            DOM.assertElement(this.delegate, (Condition)args[0]);
            return null;
        }
        return this.delegateMethod(method, args);
    }

    private Object delegateMethod(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

