/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebDriverRunner;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Condition {
    public static final Condition visible = new Condition("visible", false){

        public boolean apply(WebElement element) {
            return element != null && element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element == null ? "does not exist" : (element.isDisplayed() ? "visible" : "hidden");
        }
    };
    public static final Condition present;
    public static final Condition exist;
    public static final Condition notPresent;
    public static final Condition hidden;
    public static final Condition appears;
    public static final Condition disappears;
    public static final Condition disappear;
    public static final Condition empty;
    public static Condition options;
    public static final Condition focused;
    public static final Condition enabled;
    public static final Condition disabled;
    public static final Condition checked;
    private final String name;
    private final boolean nullIsAllowed;

    public static Condition hasAttribute(String attributeName, String attributeValue) {
        return Condition.attribute(attributeName, attributeValue);
    }

    public static Condition attribute(final String attributeName, final String attributeValue) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return element != null && attributeValue.equals(element.getAttribute(attributeName).trim());
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName + "=" + attributeValue;
            }
        };
    }

    public static Condition value(String value) {
        return Condition.hasAttribute("value", value);
    }

    public static Condition hasValue(String value) {
        return Condition.value(value);
    }

    public static Condition matchesText(String text) {
        return Condition.matchText(text);
    }

    public static Condition matchText(final String regex) {
        return new Condition("match", false){

            public boolean apply(WebElement element) {
                return element != null && Condition.matches(element.getText(), regex);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "matched text '" + regex + "'";
            }
        };
    }

    private static boolean matches(String text, String regex) {
        return Pattern.compile(".*" + regex + ".*", 32).matcher(text).matches();
    }

    public static Condition hasText(final String text) {
        return new Condition("hasText", false){

            public boolean apply(WebElement element) {
                return element != null && element.getText().contains(text);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "got text '" + text + "'";
            }
        };
    }

    public static Condition haveText(String text) {
        return Condition.hasText(text);
    }

    public static Condition text(String text) {
        return Condition.hasText(text);
    }

    public static Condition hasOptions() {
        return options;
    }

    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        String[] classNames = classes.split(" ");
        return Condition.contains(classNames, cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    public static Condition cssClass(String cssClass) {
        return Condition.hasClass(cssClass);
    }

    public static Condition hasClass(final String cssClass) {
        return new Condition("hasClass", false){

            public boolean apply(WebElement element) {
                return element != null && 9.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "got class '" + cssClass + "'";
            }
        };
    }

    public static Condition hasNotClass(final String cssClass) {
        return new Condition("hasNotClass", false){

            public boolean apply(WebElement element) {
                return element != null && !10.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "loose class '" + cssClass + "'";
            }
        };
    }

    public Condition(String name, boolean nullIsAllowed) {
        this.name = name;
        this.nullIsAllowed = nullIsAllowed;
    }

    public abstract boolean apply(WebElement var1);

    public final boolean applyNull() {
        return this.nullIsAllowed;
    }

    public abstract String actualValue(WebElement var1);

    public String toString() {
        return "become " + this.name;
    }

    static {
        exist = present = new Condition("present", false){

            public boolean apply(WebElement element) {
                return true;
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "exists";
            }
        };
        notPresent = new Condition("notPresent", true){

            public boolean apply(WebElement element) {
                return element == null;
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : "exists";
            }
        };
        hidden = new Condition("hidden", true){

            public boolean apply(WebElement element) {
                try {
                    return element == null || !element.isDisplayed();
                }
                catch (StaleElementReferenceException elementHasDisappeared) {
                    return true;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exists" : (element.isDisplayed() ? "visible" : "hidden");
            }
        };
        appears = visible;
        disappears = hidden;
        disappear = hidden;
        empty = Condition.value("");
        options = new Condition("hasOptions", false){

            public boolean apply(WebElement element) {
                try {
                    return element != null && element.getText().length() > 0;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : element.getText();
            }

            public String toString() {
                return "got any options";
            }
        };
        focused = new Condition("focused", false){

            public boolean apply(WebElement webElement) {
                return webElement.getAttribute("name").equals(WebDriverRunner.getWebDriver().findElement(By.cssSelector((String)":focus")).getAttribute("name"));
            }

            public String actualValue(WebElement webElement) {
                WebElement element = WebDriverRunner.getWebDriver().findElement(By.cssSelector((String)":focus"));
                return element == null ? "element does not exist" : element.getAttribute("name");
            }
        };
        enabled = new Condition("enabled", false){

            public boolean apply(WebElement element) {
                return element != null && element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : (element.isEnabled() ? "enabled" : "disabled");
            }
        };
        disabled = new Condition("disabled", false){

            public boolean apply(WebElement element) {
                return element != null && !element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : (element.isEnabled() ? "enabled" : "disabled");
            }
        };
        checked = new Condition("checked", false){

            public boolean apply(WebElement element) {
                return element != null && "true".equalsIgnoreCase(element.getAttribute("checked"));
            }

            public String actualValue(WebElement element) {
                return element == null ? "does not exist" : (element.isEnabled() ? "enabled" : "disabled");
            }
        };
    }
}

