/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Navigation;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.ShouldableWebElementProxy;
import com.codeborne.selenide.impl.WebElementWaitingProxy;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOM {
    public static long defaultWaitingTimeout = Long.getLong("timeout", 4000L);

    public static ShouldableWebElement $(String cssSelector) {
        return DOM.getElement(By.cssSelector((String)cssSelector));
    }

    public static ShouldableWebElement $(By seleniumSelector) {
        return DOM.getElement(seleniumSelector);
    }

    public static ShouldableWebElement $(By seleniumSelector, int index) {
        return DOM.getElement(seleniumSelector, index);
    }

    public static ShouldableWebElement $(WebElement parent, String cssSelector) {
        return WebElementWaitingProxy.wrap(parent, By.cssSelector((String)cssSelector), 0);
    }

    public static ShouldableWebElement $(String cssSelector, int index) {
        return WebElementWaitingProxy.wrap(null, By.cssSelector((String)cssSelector), index);
    }

    public static ShouldableWebElement $(WebElement parent, String cssSelector, int index) {
        return WebElementWaitingProxy.wrap(parent, By.cssSelector((String)cssSelector), index);
    }

    public static ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(DOM.getElements(By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return new ElementsCollection(DOM.getElements(seleniumSelector));
    }

    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return new ElementsCollection(parent.findElements(By.cssSelector((String)cssSelector)));
    }

    public static ShouldableWebElement getElement(By criteria) {
        return WebElementWaitingProxy.wrap(null, criteria, 0);
    }

    public static ShouldableWebElement getElement(By criteria, int index) {
        return WebElementWaitingProxy.wrap(null, criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        try {
            return new ElementsCollection(WebDriverRunner.getWebDriver().findElements(criteria));
        }
        catch (WebDriverException e) {
            return (ElementsCollection)WebDriverRunner.fail("Cannot get element " + criteria + ", caused criteria: " + (Object)((Object)e));
        }
    }

    public static void setValue(By by, String value) {
        try {
            ShouldableWebElement element = DOM.getElement(by);
            DOM.setValue(element, value);
            DOM.triggerChangeEvent(by);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(By by, int index, String value) {
        try {
            ShouldableWebElement element = DOM.getElement(by, index);
            DOM.setValue(element, value);
            DOM.triggerChangeEvent(by, index);
        }
        catch (WebDriverException e) {
            WebDriverRunner.fail("Cannot get element " + by + " and index " + index + ", caused by: " + (Object)((Object)e));
        }
    }

    public static void setValue(WebElement element, String value) {
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    public static boolean isJQueryAvailable() {
        Object result = DOM.executeJavaScript("return (typeof jQuery);");
        return !"undefined".equalsIgnoreCase(String.valueOf(result));
    }

    public static void click(By by) {
        DOM.getElement(by).click();
    }

    public static void callOnClick(By by) {
        DOM.executeJavaScript("eval(\"" + DOM.getElement(by).getAttribute("onclick") + "\")");
    }

    public static void click(By by, int index) {
        List matchedElements = WebDriverRunner.getWebDriver().findElements(by);
        if (index < 0 || index >= matchedElements.size()) {
            throw new IllegalArgumentException("Cannot click " + index + "th element: there is " + matchedElements.size() + " elements on the page");
        }
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "eq(" + index + ").click();");
        } else {
            ((WebElement)matchedElements.get(index)).click();
        }
    }

    public static void triggerChangeEvent(By by) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "change()");
        }
    }

    public static void triggerChangeEvent(By by, int index) {
        if (DOM.isJQueryAvailable()) {
            DOM.executeJQueryMethod(by, "eq(" + index + ").change()");
        }
    }

    static void executeJQueryMethod(By by, String method) {
        String selector = DOM.getJQuerySelector(by);
        if (selector != null) {
            DOM.executeJavaScript("$(\"" + selector + "\")." + method);
        } else {
            System.err.println("Warning: can't convert " + by + " to JQuery selector, unable to execute " + method);
        }
    }

    static String getJQuerySelector(By seleniumSelector) {
        if (seleniumSelector instanceof By.ByName) {
            String name = seleniumSelector.toString().replaceFirst("By\\.name:\\s*(.*)", "$1");
            return "[name='" + name + "']";
        }
        if (seleniumSelector instanceof By.ById) {
            String id = seleniumSelector.toString().replaceFirst("By\\.id:\\s*(.*)", "$1");
            return "#" + id;
        }
        if (seleniumSelector instanceof By.ByClassName) {
            String className = seleniumSelector.toString().replaceFirst("By\\.className:\\s*(.*)", "$1");
            return "." + className;
        }
        if (seleniumSelector instanceof By.ByCssSelector) {
            return seleniumSelector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1");
        }
        if (seleniumSelector instanceof By.ByXPath) {
            String seleniumXPath = seleniumSelector.toString().replaceFirst("By\\.xpath:\\s*(.*)", "$1");
            return seleniumXPath.replaceFirst("//(.*)", "$1").replaceAll("\\[@", "[");
        }
        return null;
    }

    public static Object executeJavaScript(String jsCode) {
        return ((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, new Object[0]);
    }

    public static void scrollTo(By element) {
        if (!DOM.isJQueryAvailable()) {
            throw new IllegalStateException("JQuery is not available on current page");
        }
        DOM.executeJavaScript("$.scrollTo('" + DOM.getJQuerySelector(element) + "')");
    }

    public static ShouldableWebElement selectRadio(By radioField, String value) {
        DOM.assertEnabled(radioField);
        for (WebElement radio : DOM.getElements(radioField)) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            radio.click();
            return ShouldableWebElementProxy.wrap(radio);
        }
        throw new NoSuchElementException(radioField + " and value " + value);
    }

    public static ShouldableWebElement getSelectedRadio(By radioField) {
        for (WebElement radio : DOM.getElements(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return ShouldableWebElementProxy.wrap(radio);
        }
        return null;
    }

    public static String getSelectedValue(By selectField) {
        ShouldableWebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getAttribute("value");
    }

    public static String getSelectedText(By selectField) {
        ShouldableWebElement option = DOM.findSelectedOption(selectField);
        return option == null ? null : option.getText();
    }

    private static ShouldableWebElement findSelectedOption(By selectField) {
        ShouldableWebElement selectElement = DOM.getElement(selectField);
        List options = selectElement.findElements(By.tagName((String)"option"));
        for (WebElement option : options) {
            if (option.getAttribute("selected") == null) continue;
            return ShouldableWebElementProxy.wrap(option);
        }
        return null;
    }

    public static Select select(By selectField) {
        return new Select((WebElement)DOM.getElement(selectField));
    }

    public static void selectOption(By selectField, String value) {
        DOM.select(selectField).selectByValue(value);
    }

    public static void selectOptionByText(By selectField, String text) {
        DOM.select(selectField).selectByVisibleText(text);
    }

    public static boolean existsAndVisible(By selector) {
        try {
            return WebDriverRunner.getWebDriver().findElement(selector).isDisplayed();
        }
        catch (NoSuchElementException doesNotExist) {
            return false;
        }
    }

    public static void followLink(By by) {
        ShouldableWebElement link = DOM.getElement(by);
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Navigation.navigateToAbsoluteUrl(href);
        }
    }

    private static String getActualValue(WebElement element, Condition condition) {
        try {
            return condition.actualValue(element);
        }
        catch (WebDriverException e) {
            return e.toString();
        }
    }

    public static ShouldableWebElement assertChecked(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        if (!"true".equalsIgnoreCase(element.getAttribute("checked"))) {
            throw new AssertionError((Object)("Element is not checked: " + element));
        }
        return element;
    }

    public static ShouldableWebElement assertNotChecked(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        if (element.getAttribute("checked") != null) {
            throw new AssertionError((Object)("Element is checked: " + element));
        }
        return element;
    }

    public static ShouldableWebElement assertDisabled(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        if (!"true".equalsIgnoreCase(element.getAttribute("disabled"))) {
            throw new AssertionError((Object)("Element is enabled: " + element));
        }
        return element;
    }

    public static ShouldableWebElement assertEnabled(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        String disabled = element.getAttribute("disabled");
        if (disabled != null && !"false".equalsIgnoreCase(disabled)) {
            throw new AssertionError((Object)("Element is disabled: " + element));
        }
        return element;
    }

    public static ShouldableWebElement assertSelected(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        if (!element.isSelected()) {
            throw new AssertionError((Object)("Element is not selected: " + element));
        }
        return element;
    }

    public static ShouldableWebElement assertNotSelected(By criteria) {
        ShouldableWebElement element = DOM.getElement(criteria);
        if (element.isSelected()) {
            throw new AssertionError((Object)("Element is selected: " + element));
        }
        return element;
    }

    public static boolean isVisible(By selector) {
        return DOM.getElement(selector).isDisplayed();
    }

    public static ShouldableWebElement assertVisible(By selector) {
        return DOM.assertElement(selector, Condition.visible);
    }

    public static ShouldableWebElement assertHidden(By selector) {
        return DOM.assertElement(selector, Condition.hidden);
    }

    public static ShouldableWebElement assertElement(By selector, Condition condition) {
        try {
            return DOM.assertElement(WebDriverRunner.getWebDriver().findElement(selector), condition);
        }
        catch (WebDriverException elementNotFound) {
            if (!condition.applyNull()) {
                throw elementNotFound;
            }
            return null;
        }
    }

    public static ShouldableWebElement assertElement(WebElement element, Condition condition) {
        if (!condition.apply(element)) {
            WebDriverRunner.fail("Element " + element.getTagName() + " hasn't " + condition + "; element details: '" + DOM.getActualValue(element, condition) + "'");
        }
        return ShouldableWebElementProxy.wrap(element);
    }

    public static ShouldableWebElement waitFor(By elementSelector) {
        return DOM.waitUntil(elementSelector, 0, Condition.visible, defaultWaitingTimeout);
    }

    public static ShouldableWebElement waitFor(String cssSelector) {
        return DOM.waitFor(By.cssSelector((String)cssSelector));
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, Condition condition) {
        return DOM.waitUntil(elementSelector, condition);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, Condition condition) {
        return DOM.waitUntil(elementSelector, 0, condition, defaultWaitingTimeout);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, Condition condition) {
        return DOM.waitUntil(By.cssSelector((String)cssSelector), condition);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, int index, Condition condition) {
        return DOM.waitUntil(elementSelector, index, condition, defaultWaitingTimeout);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, int index, Condition condition) {
        return DOM.waitUntil(By.cssSelector((String)cssSelector), index, condition);
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, Condition condition, long timeoutMs) {
        return DOM.waitUntil(elementSelector, condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, Condition condition, long timeoutMs) {
        return DOM.waitUntil(elementSelector, 0, condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, Condition condition, long timeoutMs) {
        return DOM.waitUntil(By.cssSelector((String)cssSelector), condition, timeoutMs);
    }

    @Deprecated
    public static ShouldableWebElement waitFor(By elementSelector, int index, Condition condition, long timeoutMs) {
        return DOM.waitUntil(elementSelector, index, condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(String cssSelector, int index, Condition condition, long timeoutMs) {
        return DOM.waitUntil(By.cssSelector((String)cssSelector), index, condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(By elementSelector, int index, Condition condition, long timeoutMs) {
        return DOM.waitUntil(null, elementSelector, index, condition, timeoutMs);
    }

    public static ShouldableWebElement waitUntil(WebElement parent, By elementSelector, int index, Condition condition) {
        return DOM.waitUntil(parent, elementSelector, index, condition, defaultWaitingTimeout);
    }

    public static ShouldableWebElement waitUntil(WebElement parent, By elementSelector, int index, Condition condition, long timeoutMs) {
        WebElement element;
        long startTime = System.currentTimeMillis();
        do {
            if ((element = DOM.tryToGetElement(parent, elementSelector, index)) != null && condition.apply(element)) {
                return ShouldableWebElementProxy.wrap(element);
            }
            if (element == null && condition.applyNull()) {
                return null;
            }
            Navigation.sleep(100L);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        return (ShouldableWebElement)WebDriverRunner.fail("Element " + elementSelector + " hasn't " + condition + " in " + timeoutMs + " ms.;" + " actual value: '" + DOM.getActualValue(element, condition) + "';" + (element == null ? "" : " element details: '" + Describe.describe(element) + "'"));
    }

    public static void waitWhile(WebElement parent, By elementSelector, int index, Condition condition) {
        DOM.waitWhile(parent, elementSelector, index, condition, defaultWaitingTimeout);
    }

    public static void waitWhile(WebElement parent, By elementSelector, int index, Condition condition, long timeoutMs) {
        WebElement element;
        long startTime = System.currentTimeMillis();
        do {
            if ((element = DOM.tryToGetElement(parent, elementSelector, index)) != null && !condition.apply(element)) {
                return;
            }
            if (element == null && !condition.applyNull()) {
                return;
            }
            Navigation.sleep(100L);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        WebDriverRunner.fail("Element " + elementSelector + " has " + condition + " in " + timeoutMs + " ms.;" + " actual value: '" + DOM.getActualValue(element, condition) + "';" + (element == null ? "" : " element details: '" + Describe.describe(element) + "'"));
    }

    private static WebElement tryToGetElement(WebElement parent, By elementSelector, int index) {
        WebElement element;
        try {
            List elements;
            element = index == 0 ? DOM.getSearchContext(parent).findElement(elementSelector) : (index < (elements = DOM.getSearchContext(parent).findElements(elementSelector)).size() ? (WebElement)elements.get(index) : null);
        }
        catch (WebDriverException elementNotFound) {
            element = null;
        }
        return element;
    }

    private static SearchContext getSearchContext(WebElement parent) {
        return parent == null ? WebDriverRunner.getWebDriver() : parent;
    }

    public static void confirm(String expectedConfirmationText) {
        try {
            Alert alert = DOM.checkAlertMessage(expectedConfirmationText);
            alert.accept();
        }
        catch (UnsupportedOperationException alertIsNotSupportedInHtmlUnit) {
            return;
        }
        DOM.waitUntilAlertDisappears();
    }

    public static void dismiss(String expectedConfirmationText) {
        try {
            Alert alert = DOM.checkAlertMessage(expectedConfirmationText);
            alert.dismiss();
        }
        catch (UnsupportedOperationException alertIsNotSupportedInHtmlUnit) {
            return;
        }
        DOM.waitUntilAlertDisappears();
    }

    private static Alert checkAlertMessage(String expectedConfirmationText) {
        Alert alert = WebDriverRunner.getWebDriver().switchTo().alert();
        if (expectedConfirmationText != null && !expectedConfirmationText.equals(alert.getText())) {
            throw new AssertionError((Object)("Actual confirmation text is '" + alert.getText() + "', but expected: '" + expectedConfirmationText + "'"));
        }
        return alert;
    }

    private static void waitUntilAlertDisappears() {
        try {
            long start = System.currentTimeMillis();
            while (WebDriverRunner.getWebDriver().switchTo().alert() != null) {
                WebDriverRunner.getWebDriver().switchTo().alert();
                if (System.currentTimeMillis() - start > defaultWaitingTimeout) {
                    WebDriverRunner.fail("Confirmation dialog has not disappeared in " + defaultWaitingTimeout + " milliseconds");
                }
                Navigation.sleep(100L);
            }
        }
        catch (NoAlertPresentException noAlertPresentException) {
            // empty catch block
        }
    }

    @Deprecated
    public static String describeElement(WebElement element) {
        return Describe.describe(element);
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return (PageObjectClass)PageFactory.initElements((WebDriver)WebDriverRunner.getWebDriver(), pageObjectClass);
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        PageFactory.initElements((WebDriver)WebDriverRunner.getWebDriver(), pageObject);
        return pageObject;
    }
}

