/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsCollection
extends ArrayList<WebElement>
implements WebElement {
    public ElementsCollection(List<WebElement> elements) {
        super(elements);
    }

    public void click() {
        for (WebElement webElement : this) {
            webElement.click();
        }
    }

    public void submit() {
        for (WebElement webElement : this) {
            webElement.submit();
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        for (WebElement webElement : this) {
            webElement.sendKeys(keysToSend);
        }
    }

    private WebElement first() {
        return (WebElement)this.get(0);
    }

    public String getTagName() {
        return this.first().getTagName();
    }

    public String getAttribute(String name) {
        return this.first().getAttribute(name);
    }

    public boolean isSelected() {
        for (WebElement webElement : this) {
            if (webElement.isSelected()) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        for (WebElement webElement : this) {
            if (webElement.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public String getText() {
        return this.first().getText();
    }

    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        for (WebElement webElement : this) {
            result.addAll(webElement.findElements(by));
        }
        return result;
    }

    public WebElement findElement(By by) {
        for (WebElement webElement : this) {
            WebElement element = webElement.findElement(by);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public boolean isDisplayed() {
        for (WebElement webElement : this) {
            if (webElement.isDisplayed()) continue;
            return false;
        }
        return true;
    }

    public Point getLocation() {
        return this.first().getLocation();
    }

    public Dimension getSize() {
        return this.first().getSize();
    }

    public String getCssValue(String propertyName) {
        return this.first().getCssValue(propertyName);
    }
}

