/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.DOM;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URL;
import org.openqa.selenium.By;

public class Navigation {
    public static String baseUrl = "http://localhost:8080";

    public static void open(String relativeUrl) {
        Navigation.navigateToAbsoluteUrl(Navigation.absoluteUrl(relativeUrl));
    }

    public static String absoluteUrl(String relativeUrl) {
        return baseUrl + relativeUrl;
    }

    public static void navigateToAbsoluteUrl(URL url) {
        Navigation.navigateToAbsoluteUrl(url.toExternalForm());
    }

    public static void navigateToAbsoluteUrl(String url) {
        if (WebDriverRunner.ie()) {
            WebDriverRunner.getWebDriver().navigate().to(Navigation.makeUniqueUrlToAvoidIECaching(url, System.nanoTime()));
            DOM.waitFor(By.tagName((String)"body"));
            Navigation.toBeSureThatPageIsNotCached();
        } else {
            WebDriverRunner.getWebDriver().navigate().to(url);
            DOM.waitFor(By.tagName((String)"body"));
        }
    }

    private static void toBeSureThatPageIsNotCached() {
        String currentUrl = WebDriverRunner.getWebDriver().getCurrentUrl();
        if (!currentUrl.contains("timestamp=")) {
            Navigation.navigateToAbsoluteUrl(currentUrl);
        }
    }

    static String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        String fullUrl = url.contains("timestamp=") ? url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique) : (url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique);
        return fullUrl;
    }

    public static void assertURL(String relativeUrl) {
        String actualUrl;
        String expectedUrl = baseUrl + relativeUrl;
        if (!expectedUrl.equals(actualUrl = WebDriverRunner.getWebDriver().getCurrentUrl().replaceFirst("\\?.*$", ""))) {
            throw new AssertionError((Object)("Actual URL " + actualUrl + " does not match with expected " + expectedUrl));
        }
    }

    public static String source() {
        return WebDriverRunner.getWebDriver().getPageSource();
    }

    public static String title() {
        return WebDriverRunner.getWebDriver().getTitle();
    }

    public static String url() {
        return WebDriverRunner.getWebDriver().getCurrentUrl();
    }

    public static void refresh() {
        Navigation.navigateToAbsoluteUrl(Navigation.url());
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

