/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Describe {
    private WebElement element;
    private StringBuilder sb = new StringBuilder();

    Describe(WebElement element) {
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    Describe attr(String attributeName) {
        String attributeValue = this.element.getAttribute(attributeName);
        if (attributeValue != null) {
            this.sb.append(' ').append(attributeName).append('=').append(attributeValue);
        }
        return this;
    }

    Describe is(String name, boolean value) {
        this.sb.append(' ').append(name).append(':').append(value);
        return this;
    }

    public String toString() {
        this.sb.append('>').append(this.element.getText()).append("</").append(this.element.getTagName()).append('>');
        return this.sb.toString();
    }

    public static String describe(WebElement element) {
        try {
            return new Describe(element).attr("id").attr("name").attr("class").attr("value").attr("disabled").attr("checked").attr("type").attr("placeholder").attr("onclick").attr("onClick").attr("onchange").attr("onChange").is("selected", element.isSelected()).is("displayed", element.isDisplayed()).is("enabled", element.isEnabled()).toString();
        }
        catch (WebDriverException elementDoesNotExist) {
            return elementDoesNotExist.toString();
        }
    }
}

