/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DOM;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ShouldableWebElementProxy
implements InvocationHandler {
    private final WebElement delegate;

    public static ShouldableWebElement wrap(WebElement element) {
        return element instanceof ShouldableWebElement ? (ShouldableWebElement)element : (ShouldableWebElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{ShouldableWebElement.class}, (InvocationHandler)new ShouldableWebElementProxy(element));
    }

    private ShouldableWebElementProxy(WebElement delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            DOM.setValue(this.delegate, (String)args[0]);
            return null;
        }
        if ("should".equals(method.getName()) || "shouldHave".equals(method.getName()) || "shouldBe".equals(method.getName())) {
            return this.should(proxy, (Condition[])args[0]);
        }
        if ("shouldNot".equals(method.getName()) || "shouldNotHave".equals(method.getName()) || "shouldNotBe".equals(method.getName())) {
            return this.shouldNot(proxy, (Condition[])args[0]);
        }
        if ("find".equals(method.getName())) {
            return ShouldableWebElementProxy.wrap(args.length == 1 ? this.find(args[0]) : this.find(args[0], (Integer)args[1]));
        }
        if ("toString".equals(method.getName())) {
            return Describe.describe(this.delegate);
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return ShouldableWebElementProxy.uploadFromClasspath(this.delegate, (String)args[0]);
        }
        return ShouldableWebElementProxy.delegateMethod(this.delegate, method, args);
    }

    static Object uploadFromClasspath(WebElement inputField, String fileName) throws URISyntaxException {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(inputField) + " is not an INPUT");
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + fileName);
        }
        File file = new File(resource.toURI());
        inputField.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        return file;
    }

    private Object should(Object proxy, Condition[] conditions) {
        for (Condition condition : conditions) {
            DOM.assertElement(this.delegate, condition);
        }
        return proxy;
    }

    private Object shouldNot(Object proxy, Condition[] conditions) {
        for (Condition condition : conditions) {
            if (!condition.apply(this.delegate)) continue;
            WebDriverRunner.fail("Element " + this.delegate.getTagName() + " has " + condition);
        }
        return proxy;
    }

    private WebElement find(Object arg) {
        return arg instanceof By ? this.delegate.findElement((By)arg) : this.delegate.findElement(By.cssSelector((String)((String)arg)));
    }

    private WebElement find(Object arg, int index) {
        return arg instanceof By ? (WebElement)this.delegate.findElements((By)arg).get(index) : (WebElement)this.delegate.findElements(By.cssSelector((String)((String)arg))).get(index);
    }

    static Object delegateMethod(WebElement delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

