/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DOM;
import com.codeborne.selenide.ShouldableWebElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.ShouldableWebElementProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class WebElementWaitingProxy
implements InvocationHandler {
    private final WebElement parent;
    private final By criteria;
    private final int index;

    public static ShouldableWebElement wrap(WebElement parent, By criteria, int index) {
        return (ShouldableWebElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ShouldableWebElement.class}, (InvocationHandler)new WebElementWaitingProxy(parent, criteria, index));
    }

    private WebElementWaitingProxy(WebElement parent, By criteria, int index) {
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            DOM.setValue(this.waitForElement(), (String)args[0]);
            return null;
        }
        if ("should".equals(method.getName()) || "shouldHave".equals(method.getName()) || "shouldBe".equals(method.getName())) {
            return this.should(proxy, (Condition[])args[0]);
        }
        if ("shouldNot".equals(method.getName()) || "shouldNotHave".equals(method.getName()) || "shouldNotBe".equals(method.getName())) {
            return this.shouldNot(proxy, (Condition[])args[0]);
        }
        if ("find".equals(method.getName())) {
            return this.find(args[0], args.length == 1 ? 0 : (Integer)args[1]);
        }
        if ("toString".equals(method.getName())) {
            return this.describe();
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return ShouldableWebElementProxy.uploadFromClasspath(this.waitForElement(), (String)args[0]);
        }
        return ShouldableWebElementProxy.delegateMethod(this.waitForElement(), method, args);
    }

    private String describe() {
        try {
            if (this.index == 0) {
                return Describe.describe(this.getSearchContext().findElement(this.criteria));
            }
            return Describe.describe((WebElement)this.getSearchContext().findElements(this.criteria).get(this.index));
        }
        catch (WebDriverException e) {
            return e.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    private Object should(Object proxy, Condition[] conditions) {
        for (Condition condition : conditions) {
            DOM.waitUntil(this.parent, this.criteria, this.index, condition);
        }
        return proxy;
    }

    private Object shouldNot(Object proxy, Condition[] conditions) {
        for (Condition condition : conditions) {
            DOM.waitWhile(this.parent, this.criteria, this.index, condition);
        }
        return proxy;
    }

    private ShouldableWebElement find(Object arg, int index) {
        return arg instanceof By ? WebElementWaitingProxy.wrap(this.waitForElement(), (By)arg, index) : WebElementWaitingProxy.wrap(this.waitForElement(), By.cssSelector((String)((String)arg)), index);
    }

    private WebElement waitForElement() {
        return DOM.waitUntil(this.parent, this.criteria, this.index, Condition.exist);
    }

    private SearchContext getSearchContext() {
        return this.parent == null ? WebDriverRunner.getWebDriver() : this.parent;
    }
}

