/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRunner {
    public static final String CHROME = "chrome";
    public static final String INTERNET_EXPLORER = "ie";
    public static final String FIREFOX = "firefox";
    public static final String HTMLUNIT = "htmlunit";
    public static final String PHANTOMJS = "phantomjs";
    public static final String OPERA = "opera";
    private static WebDriver webdriver;

    public static WebDriver getWebDriver() {
        if (webdriver == null) {
            webdriver = WebDriverRunner.createDriver();
        }
        return webdriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeWebDriver() {
        if (webdriver != null) {
            if (!Configuration.holdBrowserOpen) {
                try {
                    webdriver.close();
                }
                catch (WebDriverException cannotCloseBrowser) {
                    System.err.println("Cannot close browser normally (let's kill it): " + cannotCloseBrowser.toString());
                }
                finally {
                    WebDriverRunner.killBrowser();
                }
            }
            webdriver = null;
        }
    }

    static void killBrowser() {
        if (webdriver instanceof Killable) {
            try {
                ((Killable)webdriver).kill();
            }
            catch (Exception e) {
                System.err.println("Failed to kill browser " + webdriver + ':');
                e.printStackTrace();
            }
        }
    }

    public static boolean ie() {
        return INTERNET_EXPLORER.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean htmlUnit() {
        return HTMLUNIT.equalsIgnoreCase(Configuration.browser);
    }

    public static void clearBrowserCache() {
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    public static String source() {
        return WebDriverRunner.getWebDriver().getPageSource();
    }

    public static String url() {
        return WebDriverRunner.getWebDriver().getCurrentUrl();
    }

    public static String takeScreenShot(String fileName) {
        if (webdriver == null) {
            return null;
        }
        File targetFile = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            WebDriverRunner.writeToFile(webdriver.getPageSource(), targetFile);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        if (webdriver instanceof TakesScreenshot) {
            try {
                File scrFile = (File)((TakesScreenshot)webdriver).getScreenshotAs(OutputType.FILE);
                targetFile = new File(Configuration.reportsFolder, fileName + ".png");
                FileUtils.copyFile((File)scrFile, (File)targetFile);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return targetFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String content, File targetFile) {
        File reportsFolder = targetFile.getParentFile();
        if (!reportsFolder.exists()) {
            System.err.println("Creating folder for test reports: " + reportsFolder);
            if (!reportsFolder.mkdirs()) {
                System.err.println("Failed to create " + reportsFolder);
            }
        }
        try {
            FileWriter output = new FileWriter(targetFile);
            try {
                IOUtils.write((String)content, (Writer)output);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to write page source to file " + targetFile + ": " + e);
        }
    }

    private static WebDriver createDriver() {
        if (Configuration.remote != null) {
            return WebDriverRunner.createRemoteDriver(Configuration.remote, Configuration.browser);
        }
        if (CHROME.equalsIgnoreCase(Configuration.browser)) {
            ChromeOptions options = new ChromeOptions();
            if (Configuration.startMaximized) {
                options.addArguments(new String[]{"chrome.switches", "--start-maximized"});
            }
            return new ChromeDriver(options);
        }
        if (WebDriverRunner.ie()) {
            DesiredCapabilities ieCapabilities = DesiredCapabilities.internetExplorer();
            ieCapabilities.setCapability("ignoreProtectedModeSettings", true);
            return WebDriverRunner.maximize((RemoteWebDriver)new InternetExplorerDriver((Capabilities)ieCapabilities));
        }
        if (WebDriverRunner.htmlUnit()) {
            DesiredCapabilities desiredCapabilities = DesiredCapabilities.htmlUnit();
            desiredCapabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
            desiredCapabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
            desiredCapabilities.setJavascriptEnabled(true);
            return new HtmlUnitDriver((Capabilities)desiredCapabilities);
        }
        if (FIREFOX.equalsIgnoreCase(Configuration.browser)) {
            return WebDriverRunner.maximize((RemoteWebDriver)new FirefoxDriver());
        }
        if (OPERA.equalsIgnoreCase(Configuration.browser)) {
            return WebDriverRunner.createInstanceOf("com.opera.core.systems.OperaDriver");
        }
        if (PHANTOMJS.equals(Configuration.browser)) {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            return new PhantomJSDriver((Capabilities)capabilities);
        }
        return WebDriverRunner.createInstanceOf(Configuration.browser);
    }

    private static RemoteWebDriver maximize(RemoteWebDriver driver) {
        if (Configuration.startMaximized) {
            driver.manage().window().maximize();
        }
        return driver;
    }

    private static WebDriver createInstanceOf(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (WebDriverProvider.class.isAssignableFrom(clazz)) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver();
            }
            return (WebDriver)Class.forName(className).newInstance();
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    private static WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    public static <T> T fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static String cleanupWebDriverExceptionMessage(WebDriverException webDriverException) {
        return WebDriverRunner.cleanupWebDriverExceptionMessage(webDriverException.toString());
    }

    static String cleanupWebDriverExceptionMessage(String webDriverExceptionInfo) {
        return webDriverExceptionInfo == null || webDriverExceptionInfo.indexOf(10) == -1 ? webDriverExceptionInfo : webDriverExceptionInfo.substring(0, webDriverExceptionInfo.indexOf(10)).replaceFirst("(.*)\\(WARNING: The server did not provide any stacktrace.*", "$1").replaceFirst("org\\.openqa\\.selenium\\.(.*)", "$1").trim();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WebDriverRunner.closeWebDriver();
            }
        });
    }
}

