/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.AbstractSelenideElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ElementLocatorProxy
extends AbstractSelenideElement {
    private final ElementLocator elementLocator;

    public static SelenideElement wrap(ElementLocator elementLocator) {
        return (SelenideElement)Proxy.newProxyInstance(elementLocator.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new ElementLocatorProxy(elementLocator));
    }

    ElementLocatorProxy(ElementLocator elementLocator) {
        this.elementLocator = elementLocator;
    }

    protected WebElement getDelegate() {
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                return this.elementLocator.findElement();
            }
            catch (NoSuchElementException e) {
                NoSuchElementException exception = e;
                try {
                    Thread.sleep(Configuration.pollingInterval);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime < Configuration.timeout) continue;
                throw exception;
            }
            break;
        }
    }

    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.elementLocator.findElement();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.elementLocator + "}";
    }
}

