/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URL;
import org.openqa.selenium.By;

public class Navigator {
    public void open(String relativeOrAbsoluteUrl) {
        if (relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") || relativeOrAbsoluteUrl.startsWith("file:")) {
            this.navigateToAbsoluteUrl(relativeOrAbsoluteUrl);
        } else {
            this.navigateToAbsoluteUrl(this.absoluteUrl(relativeOrAbsoluteUrl));
        }
    }

    public void open(URL url) {
        this.navigateToAbsoluteUrl(url.toExternalForm());
    }

    protected String absoluteUrl(String relativeUrl) {
        return Configuration.baseUrl + relativeUrl;
    }

    protected void navigateToAbsoluteUrl(String url) {
        if (WebDriverRunner.ie()) {
            WebDriverRunner.getWebDriver().navigate().to(this.makeUniqueUrlToAvoidIECaching(url, System.nanoTime()));
            this.waitUntilPageIsLoaded();
            this.toBeSureThatPageIsNotCached();
        } else {
            WebDriverRunner.getWebDriver().navigate().to(url);
            this.waitUntilPageIsLoaded();
        }
    }

    protected void waitUntilPageIsLoaded() {
        Selenide.$(By.tagName((String)"body")).should(Condition.appear);
    }

    protected void toBeSureThatPageIsNotCached() {
        String currentUrl = WebDriverRunner.getWebDriver().getCurrentUrl();
        if (!currentUrl.contains("timestamp=")) {
            this.navigateToAbsoluteUrl(currentUrl);
        }
    }

    protected String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        String fullUrl = url.contains("timestamp=") ? url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique) : (url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique);
        return fullUrl;
    }
}

