/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.impl.WebDriverThreadLocalContainer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverRunner {
    public static WebDriverThreadLocalContainer webdriverContainer = new WebDriverThreadLocalContainer();
    public static final String CHROME = "chrome";
    public static final String INTERNET_EXPLORER = "ie";
    public static final String FIREFOX = "firefox";
    public static final String SAFARI = "safari";
    public static final String HTMLUNIT = "htmlunit";
    public static final String PHANTOMJS = "phantomjs";
    public static final String OPERA = "opera";

    public static void addListener(WebDriverEventListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static WebDriver getAndCheckWebDriver() {
        return webdriverContainer.getAndCheckWebDriver();
    }

    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    public static boolean isFirefox() {
        return FIREFOX.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isChrome() {
        return CHROME.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isIE() {
        return INTERNET_EXPLORER.equalsIgnoreCase(Configuration.browser);
    }

    @Deprecated
    public static boolean ie() {
        return WebDriverRunner.isIE();
    }

    public static boolean isSafari() {
        return SAFARI.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isHeadless() {
        return WebDriverRunner.isHtmlUnit() || WebDriverRunner.isPhantomjs();
    }

    public static boolean supportsModalDialogs() {
        return !WebDriverRunner.isHeadless() && !WebDriverRunner.isSafari();
    }

    public static boolean isHtmlUnit() {
        return Configuration.browser != null && Configuration.browser.startsWith(HTMLUNIT);
    }

    @Deprecated
    public static boolean htmlUnit() {
        return WebDriverRunner.isHtmlUnit();
    }

    public static boolean isPhantomjs() {
        return PHANTOMJS.equalsIgnoreCase(Configuration.browser);
    }

    @Deprecated
    public static boolean phantomjs() {
        return WebDriverRunner.isPhantomjs();
    }

    public static boolean isOpera() {
        return OPERA.equalsIgnoreCase(Configuration.browser);
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    public static String source() {
        return webdriverContainer.getPageSource();
    }

    public static String url() {
        return webdriverContainer.getCurrentUrl();
    }

    @Deprecated
    public static String takeScreenShot(String className, String methodName) {
        return Screenshots.takeScreenShot(className, methodName);
    }

    @Deprecated
    public static String takeScreenShot(String fileName) {
        return Screenshots.takeScreenShot(fileName);
    }
}

