/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.Cleanup;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Describe {
    private WebElement element;
    private StringBuilder sb = new StringBuilder();

    Describe(WebElement element) {
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    Describe attr(String attributeName) {
        String attributeValue = this.element.getAttribute(attributeName);
        if (attributeValue != null && attributeValue.length() > 0) {
            this.sb.append(' ').append(attributeName).append('=').append(attributeValue);
        }
        return this;
    }

    Describe is(String name, boolean value, boolean valueToShow) {
        if (value == valueToShow) {
            this.sb.append(' ').append(name).append(':').append(value);
        }
        return this;
    }

    public String toString() {
        String text = this.element.getText();
        this.sb.append('>').append(text == null ? "" : text).append("</").append(this.element.getTagName()).append('>');
        return this.sb.toString();
    }

    public static String describe(WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            return new Describe(element).attr("id").attr("name").attr("class").attr("href").attr("value").attr("disabled").attr("type").attr("placeholder").attr("onclick").attr("onClick").attr("onchange").attr("onChange").is("selected", Describe.isSelected(element), true).is("displayed", element.isDisplayed(), false).is("enabled", element.isEnabled(), false).toString();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage((Exception)((Object)elementDoesNotExist));
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    public static String shortly(WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            return new Describe(element).attr("id").attr("name").toString();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage((Exception)((Object)elementDoesNotExist));
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    private static boolean isSelected(WebElement element) {
        try {
            return element.isSelected();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        catch (InvalidElementStateException e) {
            return false;
        }
    }
}

