/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URL;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    public void open(String relativeOrAbsoluteUrl) {
        if (relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") || this.isLocalFile(relativeOrAbsoluteUrl)) {
            this.navigateToAbsoluteUrl(relativeOrAbsoluteUrl);
        } else {
            this.navigateToAbsoluteUrl(this.absoluteUrl(relativeOrAbsoluteUrl));
        }
    }

    public void open(URL url) {
        this.navigateToAbsoluteUrl(url.toExternalForm());
    }

    protected String absoluteUrl(String relativeUrl) {
        return Configuration.baseUrl + relativeUrl;
    }

    protected void navigateToAbsoluteUrl(String url) {
        if (WebDriverRunner.isIE() && !this.isLocalFile(url)) {
            url = this.makeUniqueUrlToAvoidIECaching(url, System.nanoTime());
        }
        try {
            WebDriver webdriver = WebDriverRunner.getAndCheckWebDriver();
            webdriver.navigate().to(url);
            this.collectJavascriptErrors((JavascriptExecutor)webdriver);
        }
        catch (WebDriverException e) {
            e.addInfo("selenide.url", url);
            e.addInfo("selenide.baseUrl", Configuration.baseUrl);
            throw e;
        }
    }

    protected void collectJavascriptErrors(JavascriptExecutor webdriver) {
        webdriver.executeScript("window._selenide_jsErrors = [];\nif (!window.onerror) {\n  window.onerror = function (errorMessage, url, lineNumber) {\n    var message = errorMessage + ' at ' + url + ':' + lineNumber;\n    window._selenide_jsErrors.push(message);\n    return false;\n  }\n};\n", new Object[0]);
    }

    protected String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        if (url.contains("timestamp=")) {
            return url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique);
        }
        return url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique;
    }

    protected boolean isLocalFile(String url) {
        return url.startsWith("file:");
    }

    public void back() {
        WebDriverRunner.getWebDriver().navigate().back();
    }

    public void forward() {
        WebDriverRunner.getWebDriver().navigate().forward();
    }
}

