/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.JQuery;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.AbstractSelenideElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WaitingSelenideElement
extends AbstractSelenideElement {
    private final SearchContext parent;
    private final By criteria;
    private final int index;

    public static SelenideElement wrap(By criteria) {
        return WaitingSelenideElement.wrap(null, criteria, 0);
    }

    public static SelenideElement wrap(SearchContext parent, By criteria, int index) {
        return (SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new WaitingSelenideElement(parent, criteria, index));
    }

    WaitingSelenideElement(SearchContext parent, By criteria, int index) {
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    @Override
    protected WebElement getDelegate() {
        return this.waitUntil("", Condition.exist, Configuration.timeout);
    }

    @Override
    protected SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return arg instanceof By ? WaitingSelenideElement.wrap((SearchContext)proxy, (By)arg, index) : WaitingSelenideElement.wrap((SearchContext)proxy, By.cssSelector((String)((String)arg)), index);
    }

    @Override
    protected void selectOptionByText(WebElement selectField, String optionText) {
        super.selectOptionByText(selectField, optionText);
        JQuery.jQuery.change(this.criteria, this.index);
    }

    @Override
    protected void selectOptionByValue(WebElement selectField, String optionValue) {
        super.selectOptionByValue(selectField, optionValue);
        JQuery.jQuery.change(this.criteria, this.index);
    }

    @Override
    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? this.getSearchContext().findElement(this.criteria) : (WebElement)this.getSearchContext().findElements(this.criteria).get(this.index);
    }

    private SearchContext getSearchContext() {
        return this.parent == null ? WebDriverRunner.getWebDriver() : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).toWebElement() : this.parent);
    }

    @Override
    String getSearchCriteria() {
        return this.index == 0 ? this.criteria.toString() : this.criteria.toString() + '[' + this.index + ']';
    }

    public String toString() {
        return "{" + this.getSearchCriteria() + '}';
    }
}

