/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Cleanup;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer {
    protected List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    protected Collection<Thread> ALL_WEB_DRIVERS_THREADS = new ConcurrentLinkedQueue<Thread>();
    protected Map<Long, WebDriver> THREAD_WEB_DRIVER = new ConcurrentHashMap<Long, WebDriver>(4);
    protected final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    protected void closeUnusedWebdrivers() {
        for (Thread thread : this.ALL_WEB_DRIVERS_THREADS) {
            if (thread.isAlive()) continue;
            this.closeWebDriver(thread);
        }
    }

    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    public WebDriver setWebDriver(WebDriver webDriver) {
        this.THREAD_WEB_DRIVER.put(Thread.currentThread().getId(), webDriver);
        return webDriver;
    }

    protected boolean isBrowserStillOpen(WebDriver webDriver) {
        try {
            webDriver.manage().window().getSize();
            return true;
        }
        catch (UnreachableBrowserException e) {
            return false;
        }
        catch (NoSuchWindowException e) {
            return false;
        }
        catch (SessionNotFoundException e) {
            return false;
        }
    }

    public WebDriver getWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        return webDriver != null ? webDriver : this.setWebDriver(this.createDriver());
    }

    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            if (this.isBrowserStillOpen(webDriver)) {
                return webDriver;
            }
            System.out.println("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
        }
        return this.setWebDriver(this.createDriver());
    }

    public void closeWebDriver() {
        this.closeWebDriver(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWebDriver(Thread thread) {
        this.ALL_WEB_DRIVERS_THREADS.remove(thread);
        WebDriver webdriver = this.THREAD_WEB_DRIVER.remove(thread.getId());
        System.out.println(" === CLOSE WEBDRIVER: " + Thread.currentThread().getId() + " -> " + webdriver);
        if (webdriver != null && !Configuration.holdBrowserOpen) {
            try {
                webdriver.quit();
            }
            catch (WebDriverException cannotCloseBrowser) {
                System.err.println("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage((Exception)((Object)cannotCloseBrowser)));
            }
            finally {
                this.killBrowser(webdriver);
            }
        }
    }

    protected void killBrowser(WebDriver webdriver) {
        if (webdriver instanceof Killable) {
            try {
                ((Killable)webdriver).kill();
            }
            catch (Exception e) {
                System.err.println("Failed to kill browser " + webdriver + ':');
                e.printStackTrace();
            }
        }
    }

    public void clearBrowserCache() {
        WebDriver webdriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    protected WebDriver createDriver() {
        WebDriver webdriver = Configuration.remote != null ? this.createRemoteDriver(Configuration.remote, Configuration.browser) : ("chrome".equalsIgnoreCase(Configuration.browser) ? this.createChromeDriver() : (WebDriverRunner.isFirefox() ? this.createFirefoxDriver() : (WebDriverRunner.isHtmlUnit() ? this.createHtmlUnitDriver() : (WebDriverRunner.isIE() ? this.createInternetExplorerDriver() : (WebDriverRunner.isPhantomjs() ? this.createPhantomJsDriver() : (WebDriverRunner.isOpera() ? this.createOperaDriver() : (WebDriverRunner.isSafari() ? this.createSafariDriver() : this.createInstanceOf(Configuration.browser))))))));
        webdriver = this.maximize(webdriver);
        System.out.println(" === CREATE WEBDRIVER: " + Thread.currentThread().getId() + " -> " + webdriver);
        return this.markForAutoClose(this.listeners.isEmpty() ? webdriver : this.addListeners(webdriver));
    }

    protected WebDriver addListeners(WebDriver webdriver) {
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : this.listeners) {
            wrapper.register(listener);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebDriver markForAutoClose(WebDriver webDriver) {
        this.ALL_WEB_DRIVERS_THREADS.add(Thread.currentThread());
        if (!this.cleanupThreadStarted.get()) {
            AtomicBoolean atomicBoolean = this.cleanupThreadStarted;
            synchronized (atomicBoolean) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread().start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new WebdriversFinalCleanupThread(Thread.currentThread()));
        return webDriver;
    }

    protected WebDriver createChromeDriver() {
        return new ChromeDriver();
    }

    protected WebDriver createFirefoxDriver() {
        return new FirefoxDriver();
    }

    protected WebDriver createHtmlUnitDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        capabilities.setJavascriptEnabled(true);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver() {
        return new InternetExplorerDriver();
    }

    protected WebDriver createPhantomJsDriver() {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver");
    }

    protected WebDriver createOperaDriver() {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver");
    }

    protected WebDriver createSafariDriver() {
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver");
    }

    protected WebDriver maximize(WebDriver driver) {
        if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                System.out.println("Cannot maximize " + Configuration.browser + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenResolution = new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    protected WebDriver createInstanceOf(String className) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            Class<?> clazz = Class.forName(className);
            if (WebDriverProvider.class.isAssignableFrom(clazz)) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    protected class UnusedWebdriversCleanupThread
    extends Thread {
        public UnusedWebdriversCleanupThread() {
            this.setDaemon(true);
            this.setName("Webdrivers killer thread");
        }

        @Override
        public void run() {
            while (true) {
                WebDriverThreadLocalContainer.this.closeUnusedWebdrivers();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    protected class WebdriversFinalCleanupThread
    extends Thread {
        private final Thread thread;

        public WebdriversFinalCleanupThread(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            WebDriverThreadLocalContainer.this.closeWebDriver(this.thread);
        }
    }
}

