/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.AbstractSelenideElement;
import com.codeborne.selenide.impl.Describe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class WebElementProxy
extends AbstractSelenideElement {
    private final WebElement delegate;

    public static SelenideElement wrap(WebElement element) {
        return element instanceof SelenideElement ? (SelenideElement)element : (SelenideElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new WebElementProxy(element));
    }

    WebElementProxy(WebElement delegate) {
        this.delegate = delegate;
    }

    @Override
    protected WebElement getDelegate() {
        return this.delegate;
    }

    @Override
    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.getDelegate();
    }

    @Override
    protected String getSearchCriteria() {
        return this.delegate.toString();
    }

    public String toString() {
        return Describe.describe(this.delegate);
    }
}

