/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.impl.Quotes;
import org.openqa.selenium.By;

public class Selectors {
    public static By withText(String elementText) {
        return new WithText(elementText);
    }

    public static By byText(String elementText) {
        return new ByText(elementText);
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        return By.xpath((String)(".//*[@" + attributeName + '=' + Quotes.escape.quotes(attributeValue) + ']'));
    }

    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }

    public static class WithText
    extends By.ByXPath {
        protected final String elementText;

        public WithText(String elementText) {
            super(".//*/text()[contains(normalize-space(.), " + Quotes.escape.quotes(elementText) + ")]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "with text: " + this.elementText;
        }
    }

    public static class ByText
    extends By.ByXPath {
        protected final String elementText;

        public ByText(String elementText) {
            super(".//*/text()[normalize-space(.) = " + Quotes.escape.quotes(elementText) + "]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "by text: " + this.elementText;
        }
    }
}

