/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.JQuery;
import com.codeborne.selenide.Selectors;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.FileDownloader;
import com.codeborne.selenide.impl.SelenideLog;
import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import com.codeborne.selenide.impl.WebElementProxy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

abstract class AbstractSelenideElement
implements InvocationHandler {
    protected Exception lastError;
    private static final Set<String> methodsToSkipLogging = new HashSet<String>(Arrays.asList("toWebElement", "toString"));

    AbstractSelenideElement() {
    }

    abstract WebElement getDelegate();

    abstract WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException;

    abstract String getSearchCriteria();

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        if (methodsToSkipLogging.contains(method.getName())) {
            return this.dispatch(proxy, method, args);
        }
        SelenideLog log = SelenideLogger.beginStep(this.getSearchCriteria(), method.getName(), args);
        try {
            Object result = this.dispatch(proxy, method, args);
            SelenideLogger.commitStep(log, SelenideLogger.EventStatus.PASSED);
            return result;
        }
        catch (Throwable t) {
            SelenideLogger.commitStep(log, SelenideLogger.EventStatus.FAILED);
            throw t;
        }
    }

    protected Object dispatch(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("val".equals(method.getName())) {
            if (args == null || args.length == 0) {
                return this.getValue();
            }
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("attr".equals(method.getName())) {
            return this.getDelegate().getAttribute((String)args[0]);
        }
        if ("name".equals(method.getName())) {
            return this.getDelegate().getAttribute("name");
        }
        if ("data".equals(method.getName())) {
            return this.getDelegate().getAttribute("data-" + args[0]);
        }
        if ("append".equals(method.getName())) {
            this.append((String)args[0]);
            return proxy;
        }
        if ("pressEnter".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.ENTER});
            return proxy;
        }
        if ("pressTab".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.TAB});
            return proxy;
        }
        if ("followLink".equals(method.getName())) {
            this.followLink();
            return null;
        }
        if ("text".equals(method.getName())) {
            return this.getDelegate().getText();
        }
        if ("innerText".equals(method.getName())) {
            return this.getInnerText();
        }
        if ("innerHtml".equals(method.getName())) {
            return this.getInnerHtml();
        }
        if ("should".equals(method.getName())) {
            return this.invokeShould(proxy, "", args);
        }
        if ("shouldHave".equals(method.getName())) {
            return this.invokeShould(proxy, "have ", args);
        }
        if ("shouldBe".equals(method.getName())) {
            return this.invokeShould(proxy, "be ", args);
        }
        if ("shouldNot".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "", args);
        }
        if ("shouldNotHave".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "have ", args);
        }
        if ("shouldNotBe".equals(method.getName())) {
            return this.invokeShouldNot(proxy, "be ", args);
        }
        if ("parent".equals(method.getName())) {
            return this.parent((SelenideElement)proxy);
        }
        if ("closest".equals(method.getName())) {
            return this.closest((SelenideElement)proxy, (String)args[0]);
        }
        if ("find".equals(method.getName()) || "$".equals(method.getName())) {
            return args.length == 1 ? this.find((SelenideElement)proxy, args[0], 0) : this.find((SelenideElement)proxy, args[0], (Integer)args[1]);
        }
        if ("findAll".equals(method.getName()) || "$$".equals(method.getName())) {
            SelenideElement parent = (SelenideElement)proxy;
            return new ElementsCollection(new BySelectorCollection(parent, this.getSelector(args[0])));
        }
        if ("toString".equals(method.getName())) {
            return this.describe();
        }
        if ("exists".equals(method.getName())) {
            return this.exists();
        }
        if ("isDisplayed".equals(method.getName())) {
            return this.isDisplayed();
        }
        if ("is".equals(method.getName()) || "has".equals(method.getName())) {
            return this.matches((Condition)args[0]);
        }
        if ("setSelected".equals(method.getName())) {
            this.setSelected((Boolean)args[0]);
            return proxy;
        }
        if ("uploadFile".equals(method.getName())) {
            return this.uploadFile((SelenideElement)proxy, (File[])args[0]);
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return this.uploadFromClasspath((SelenideElement)proxy, (String[])args[0]);
        }
        if ("selectOption".equals(method.getName())) {
            this.selectOptionByText(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("selectOptionByValue".equals(method.getName())) {
            this.selectOptionByValue(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("getSelectedOption".equals(method.getName())) {
            return this.getSelectedOption(this.getDelegate());
        }
        if ("getSelectedValue".equals(method.getName())) {
            return this.getSelectedValue(this.getDelegate());
        }
        if ("getSelectedText".equals(method.getName())) {
            return this.getSelectedText(this.getDelegate());
        }
        if ("toWebElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("waitUntil".equals(method.getName())) {
            if (args[0] instanceof String) {
                this.waitUntil("", (String)args[0], (Condition)args[1], (Long)args[2]);
            } else {
                this.waitUntil("", (Condition)args[0], (Long)args[1]);
            }
            return proxy;
        }
        if ("waitWhile".equals(method.getName())) {
            if (args[0] instanceof String) {
                this.waitWhile("", (String)args[0], (Condition)args[1], (Long)args[2]);
            } else {
                this.waitWhile("", (Condition)args[0], (Long)args[1]);
            }
            return proxy;
        }
        if ("scrollTo".equals(method.getName())) {
            this.scrollTo();
            return proxy;
        }
        if ("download".equals(method.getName())) {
            return this.download();
        }
        if ("click".equals(method.getName())) {
            this.click();
            return null;
        }
        if ("contextClick".equals(method.getName())) {
            this.contextClick();
            return null;
        }
        if ("hover".equals(method.getName())) {
            this.hover();
            return null;
        }
        if ("dragAndDropTo".equals(method.getName())) {
            this.dragAndDropTo((String)args[0]);
            return null;
        }
        if ("getWrappedElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("isImage".equals(method.getName())) {
            return this.isImage();
        }
        return AbstractSelenideElement.delegateMethod(this.getDelegate(), method, args);
    }

    protected Object invokeShould(Object proxy, String prefix, Object[] args) {
        if (args[0] instanceof String) {
            return this.should(proxy, prefix, (String)args[0], (Condition[])args[1]);
        }
        return this.should(proxy, prefix, (Condition[])args[0]);
    }

    protected Object invokeShouldNot(Object proxy, String prefix, Object[] args) {
        if (args[0] instanceof String) {
            return this.shouldNot(proxy, prefix, (String)args[0], (Condition[])args[1]);
        }
        return this.shouldNot(proxy, prefix, (Condition[])args[0]);
    }

    protected Boolean isImage() {
        WebElement img = this.getActualDelegate();
        if (!"img".equalsIgnoreCase(img.getTagName())) {
            throw new IllegalArgumentException("Method isImage() is only applicable for img elements");
        }
        return (Boolean)Selenide.executeJavaScript("return arguments[0].complete && typeof arguments[0].naturalWidth != 'undefined' && arguments[0].naturalWidth > 0", img);
    }

    protected boolean matches(Condition condition) {
        try {
            WebElement element = this.tryToGetElement();
            if (element != null) {
                return condition.apply(element);
            }
        }
        catch (WebDriverException elementNotFound) {
            this.lastError = elementNotFound;
        }
        catch (IndexOutOfBoundsException ignore) {
            this.lastError = ignore;
        }
        if (Cleanup.of.isInvalidSelectorError(this.lastError)) {
            throw Cleanup.of.wrap(this.lastError);
        }
        return condition.applyNull();
    }

    protected void setSelected(boolean selected) {
        WebElement element = this.waitForElement();
        if (element.isSelected() ^ selected) {
            element.click();
        }
    }

    protected String getInnerText() {
        WebElement element = this.waitUntil("", Condition.exist, Configuration.timeout);
        if (WebDriverRunner.isHtmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerText", element);
        }
        if (WebDriverRunner.isIE()) {
            return element.getAttribute("innerText");
        }
        return element.getAttribute("textContent");
    }

    protected String getInnerHtml() {
        WebElement element = this.waitUntil("", Condition.exist, Configuration.timeout);
        if (WebDriverRunner.isHtmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerHTML", element);
        }
        return element.getAttribute("innerHTML");
    }

    protected WebElement waitForElement() {
        return this.waitUntil("be ", Condition.visible, Configuration.timeout);
    }

    protected void click() {
        this.waitForElement().click();
    }

    protected void contextClick() {
        Selenide.actions().contextClick(this.waitForElement()).perform();
    }

    protected void hover() {
        Selenide.actions().moveToElement(this.waitForElement()).perform();
    }

    protected void dragAndDropTo(String targetCssSelector) {
        SelenideElement target = Selenide.$(targetCssSelector).shouldBe(Condition.visible);
        Selenide.actions().dragAndDrop(this.waitForElement(), (WebElement)target).perform();
    }

    protected void followLink() {
        WebElement link = this.waitForElement();
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Selenide.open(href);
        }
    }

    protected void setValue(String text) {
        WebElement element = this.waitForElement();
        if ("select".equalsIgnoreCase(element.getTagName())) {
            this.selectOptionByValue(element, text);
        } else if (text == null || text.isEmpty()) {
            element.clear();
        } else if (Configuration.fastSetValue && JQuery.jQuery.isJQueryAvailable()) {
            String jsCodeToTriggerEvent = "arguments[0].value = arguments[1];var element = jQuery(arguments[0]);var e = jQuery.Event('keydown');  e.which = arguments[2]; element.trigger(e);var e = jQuery.Event('keypress'); e.which = arguments[2]; element.trigger(e);var e = jQuery.Event('keyup');    e.which = arguments[2]; element.trigger(e);";
            char lastChar = text.charAt(text.length() - 1);
            Selenide.executeJavaScript(jsCodeToTriggerEvent, element, text, lastChar);
            this.fireChangeEvent(element);
        } else if (Configuration.fastSetValue) {
            Selenide.executeJavaScript("arguments[0].value = arguments[1]", element, text);
            this.fireChangeEvent(element);
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{text});
            this.fireChangeEvent(element);
        }
    }

    protected void fireChangeEvent(WebElement element) {
        try {
            this.fireEvent(element, "change");
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            // empty catch block
        }
    }

    protected String getValue() {
        return this.getDelegate().getAttribute("value");
    }

    protected void append(String text) {
        WebElement element = this.waitForElement();
        element.sendKeys(new CharSequence[]{text});
        this.fireChangeEvent(element);
    }

    protected void fireEvent(WebElement element, String event) {
        String jsCodeToTriggerEvent = "if (document.createEventObject) {\n  var evt = document.createEventObject();\n  return arguments[0].fireEvent('on' + arguments[1], evt);\n}\nelse {\n  var evt = document.createEvent('HTMLEvents');\n   evt.initEvent(arguments[1], true, true );\n   return !arguments[0].dispatchEvent(evt);\n}";
        Selenide.executeJavaScript("if (document.createEventObject) {\n  var evt = document.createEventObject();\n  return arguments[0].fireEvent('on' + arguments[1], evt);\n}\nelse {\n  var evt = document.createEvent('HTMLEvents');\n   evt.initEvent(arguments[1], true, true );\n   return !arguments[0].dispatchEvent(evt);\n}", element, event);
    }

    protected Object should(Object proxy, String prefix, Condition ... conditions) {
        return this.should(proxy, prefix, (String)null, conditions);
    }

    protected Object should(Object proxy, String prefix, String message, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitUntil(prefix, message, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected Object shouldNot(Object proxy, String prefix, Condition ... conditions) {
        return this.shouldNot(proxy, prefix, (String)null, conditions);
    }

    protected Object shouldNot(Object proxy, String prefix, String message, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitWhile(prefix, message, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected File uploadFromClasspath(SelenideElement inputField, String ... fileName) throws URISyntaxException, IOException {
        File[] files = new File[fileName.length];
        for (int i = 0; i < fileName.length; ++i) {
            files[i] = this.findFileInClasspath(fileName[i]);
        }
        return this.uploadFile(inputField, files);
    }

    protected File findFileInClasspath(String name) throws URISyntaxException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + name);
        }
        return new File(resource.toURI());
    }

    protected File uploadFile(SelenideElement inputField, File ... file) throws IOException {
        if (file.length == 0) {
            throw new IllegalArgumentException("No files to upload");
        }
        File uploadedFile = this.uploadFile((WebElement)inputField, file[0]);
        if (file.length > 1) {
            SelenideElement form = inputField.closest("form");
            for (int i = 1; i < file.length; ++i) {
                this.uploadFile(this.cloneInputField(form, inputField), file[i]);
            }
        }
        return uploadedFile;
    }

    protected WebElement cloneInputField(SelenideElement form, SelenideElement inputField) {
        return (WebElement)Selenide.executeJavaScript("var fileInput = document.createElement('input');fileInput.setAttribute('type', arguments[1].getAttribute('type'));fileInput.setAttribute('name', arguments[1].getAttribute('name'));fileInput.style.width = '1px';fileInput.style.height = '1px';arguments[0].appendChild(fileInput);return fileInput;", form, inputField);
    }

    protected File uploadFile(WebElement inputField, File file) throws IOException {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(inputField) + " is not an INPUT");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file.getAbsolutePath());
        }
        String canonicalPath = file.getCanonicalPath();
        inputField.sendKeys(new CharSequence[]{canonicalPath});
        return new File(canonicalPath);
    }

    protected void selectOptionByText(WebElement selectField, String optionText) {
        Selenide.$(selectField).should(Condition.exist).find(Selectors.byText(optionText)).shouldBe(Condition.visible);
        new Select(selectField).selectByVisibleText(optionText);
    }

    protected void selectOptionByValue(WebElement selectField, String optionValue) {
        Selenide.$(selectField).should(Condition.exist).find(Selectors.byValue(optionValue)).shouldBe(Condition.visible);
        new Select(selectField).selectByValue(optionValue);
    }

    protected String getSelectedValue(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getAttribute("value");
    }

    protected String getSelectedText(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getText();
    }

    protected SelenideElement getSelectedOption(WebElement selectElement) {
        return WebElementProxy.wrap(new Select(selectElement).getFirstSelectedOption());
    }

    protected boolean exists() {
        try {
            return this.getActualDelegate() != null;
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((Exception)((Object)elementNotFound));
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected boolean isDisplayed() {
        try {
            WebElement element = this.getActualDelegate();
            return element != null && element.isDisplayed();
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((Exception)((Object)elementNotFound));
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected String describe() {
        try {
            return Describe.describe(this.getActualDelegate());
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage((Exception)((Object)elementDoesNotExist));
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return invalidElementIndex.toString();
        }
    }

    static Object delegateMethod(WebElement delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected WebElement waitUntil(String prefix, Condition condition, long timeoutMs) {
        return this.waitUntil(prefix, null, condition, timeoutMs);
    }

    protected WebElement waitUntil(String prefix, String message, Condition condition, long timeoutMs) {
        WebElement element;
        long startTime = System.currentTimeMillis();
        do {
            this.lastError = null;
            element = this.tryToGetElement();
            if (element != null) {
                try {
                    if (condition.apply(element)) {
                        return element;
                    }
                }
                catch (WebDriverException elementNotFound) {
                    this.lastError = elementNotFound;
                }
                catch (IndexOutOfBoundsException ignore) {
                    this.lastError = ignore;
                }
            } else if (condition.applyNull()) {
                if (Cleanup.of.isInvalidSelectorError(this.lastError)) {
                    throw Cleanup.of.wrap(this.lastError);
                }
                return null;
            }
            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime <= timeoutMs);
        if (Cleanup.of.isInvalidSelectorError(this.lastError)) {
            throw Cleanup.of.wrap(this.lastError);
        }
        if (!this.exists(element)) {
            return this.throwElementNotFound(condition, timeoutMs);
        }
        throw new ElementShould(this.getSearchCriteria(), prefix, message, condition, element, this.lastError, timeoutMs);
    }

    protected WebElement throwElementNotFound(Condition condition, long timeoutMs) {
        throw new ElementNotFound(this.getSearchCriteria(), condition, this.lastError, timeoutMs);
    }

    protected void waitWhile(String prefix, Condition condition, long timeoutMs) {
        this.waitWhile(prefix, null, condition, timeoutMs);
    }

    protected void waitWhile(String prefix, String message, Condition condition, long timeoutMs) {
        WebElement element;
        long startTime = System.currentTimeMillis();
        do {
            this.lastError = null;
            element = this.tryToGetElement();
            if (element != null) {
                try {
                    if (!condition.apply(element)) {
                        return;
                    }
                }
                catch (WebDriverException elementNotFound) {
                    this.lastError = elementNotFound;
                }
                catch (IndexOutOfBoundsException ignore) {
                    this.lastError = ignore;
                }
            } else if (!condition.applyNull()) {
                if (Cleanup.of.isInvalidSelectorError(this.lastError)) {
                    throw Cleanup.of.wrap(this.lastError);
                }
                return;
            }
            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime <= timeoutMs);
        if (Cleanup.of.isInvalidSelectorError(this.lastError)) {
            throw Cleanup.of.wrap(this.lastError);
        }
        if (this.exists(element)) {
            throw new ElementShouldNot(this.getSearchCriteria(), prefix, message, condition, element, this.lastError, timeoutMs);
        }
        this.throwElementNotFound(Condition.not(condition), timeoutMs);
    }

    protected boolean exists(WebElement element) {
        try {
            if (element == null) {
                return false;
            }
            element.isDisplayed();
            return true;
        }
        catch (WebDriverException elementNotFound) {
            return false;
        }
    }

    protected WebElement tryToGetElement() {
        try {
            return this.getActualDelegate();
        }
        catch (WebDriverException elementNotFound) {
            this.lastError = elementNotFound;
            return null;
        }
        catch (IndexOutOfBoundsException ignore) {
            this.lastError = ignore;
            return null;
        }
        catch (RuntimeException e) {
            throw Cleanup.of.wrap(e);
        }
    }

    protected SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return WaitingSelenideElement.wrap((SearchContext)proxy, this.getSelector(arg), index);
    }

    protected By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    protected SelenideElement parent(SelenideElement me) {
        return this.find(me, By.xpath((String)".."), 0);
    }

    protected SelenideElement closest(SelenideElement me, String tagOrClass) {
        return tagOrClass.startsWith(".") ? this.find(me, By.xpath((String)("ancestor::*[contains(concat(' ', normalize-space(@class), ' '), ' " + tagOrClass.substring(1) + " ')][1]")), 0) : this.find(me, By.xpath((String)("ancestor::" + tagOrClass + "[1]")), 0);
    }

    protected void scrollTo() {
        Point location = this.getDelegate().getLocation();
        Selenide.executeJavaScript("window.scrollTo(" + location.getX() + ", " + location.getY() + ')', new Object[0]);
    }

    protected File download() throws IOException, URISyntaxException {
        return FileDownloader.instance.download(this.getDelegate());
    }
}

