/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.LogEvent;

public class SelenideLog
implements LogEvent {
    private final long startNs;
    private long endNs;
    private final String subject;
    private final String element;
    private SelenideLogger.EventStatus status = SelenideLogger.EventStatus.IN_PROGRESS;

    public SelenideLog(String element, String subject) {
        this.element = element;
        this.subject = subject;
        this.startNs = System.nanoTime();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getStatus() {
        return this.status.name();
    }

    protected void setStatus(SelenideLogger.EventStatus status) {
        this.status = status;
        this.endNs = System.nanoTime();
    }

    @Override
    public String getElement() {
        return this.element;
    }

    @Override
    public long getDuration() {
        return (this.endNs - this.startNs) / 1000000L;
    }

    public String toString() {
        return "$(" + this.element + ") " + this.subject;
    }
}

