/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class WebElementSelector {
    public static WebElementSelector instance = new WebElementSelector();
    protected String sizzleSource;

    public WebElement findElement(SearchContext context, By selector) {
        if (Configuration.selectorMode == Configuration.SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return context.findElement(selector);
        }
        List<WebElement> webElements = this.evaluateSizzleSelector(context, (By.ByCssSelector)selector);
        return webElements.isEmpty() ? null : webElements.get(0);
    }

    public List<WebElement> findElements(SearchContext context, By selector) {
        if (Configuration.selectorMode == Configuration.SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return context.findElements(selector);
        }
        return this.evaluateSizzleSelector(context, (By.ByCssSelector)selector);
    }

    protected List<WebElement> evaluateSizzleSelector(SearchContext context, By.ByCssSelector sizzleCssSelector) {
        this.injectSizzleIfNeeded();
        String sizzleSelector = sizzleCssSelector.toString().replace("By.selector: ", "");
        if (context instanceof WebElement) {
            return (List)Selenide.executeJavaScript("return Sizzle(arguments[0], arguments[1])", sizzleSelector, context);
        }
        return (List)Selenide.executeJavaScript("return Sizzle(arguments[0])", sizzleSelector);
    }

    protected void injectSizzleIfNeeded() {
        if (!this.sizzleLoaded().booleanValue()) {
            this.injectSizzle();
        }
    }

    protected Boolean sizzleLoaded() {
        try {
            return (Boolean)Selenide.executeJavaScript("return Sizzle() != null", new Object[0]);
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    protected synchronized void injectSizzle() {
        if (this.sizzleSource == null) {
            try {
                this.sizzleSource = IOUtils.toString((URL)Thread.currentThread().getContextClassLoader().getResource("sizzle.js"));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load sizzle.js from classpath", e);
            }
        }
        Selenide.executeJavaScript(this.sizzleSource, new Object[0]);
    }
}

