/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.TextsMismatch;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebElement;

public class ExactTexts
extends CollectionCondition {
    protected final String[] expectedTexts;

    public ExactTexts(String ... expectedTexts) {
        if (expectedTexts.length == 0) {
            throw new IllegalArgumentException("Array of expected texts is empty");
        }
        this.expectedTexts = expectedTexts;
    }

    public boolean apply(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.length) {
            return false;
        }
        for (int i = 0; i < this.expectedTexts.length; ++i) {
            WebElement element = elements.get(i);
            String expectedText = this.expectedTexts[i];
            if (Html.text.equals(element.getText(), expectedText)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void fail(WebElementsCollection collection, List<WebElement> elements, Exception lastError, long timeoutMs) {
        if (elements == null || elements.isEmpty()) {
            throw new ElementNotFound(collection, this.expectedTexts, lastError, timeoutMs);
        }
        throw new TextsMismatch(collection, ElementsCollection.getTexts(elements), this.expectedTexts, timeoutMs);
    }

    public String toString() {
        return "Exact texts " + Arrays.toString(this.expectedTexts);
    }
}

