/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ex.ErrorMessages;
import java.util.List;

public class UIAssertionError
extends AssertionError {
    private final String screenshot = ErrorMessages.formatScreenShotPath();
    private final List<String> jsErrors = Selenide.getJavascriptErrors();
    private final String detailedMessage;

    protected UIAssertionError(String message) {
        super((Object)message);
        this.detailedMessage = message + ErrorMessages.screenshot(this.screenshot) + ErrorMessages.jsErrors(this.jsErrors);
    }

    protected UIAssertionError(String message, long timeoutMs) {
        super((Object)message);
        this.detailedMessage = message + ErrorMessages.screenshot(this.screenshot) + ErrorMessages.jsErrors(this.jsErrors) + ErrorMessages.timeout(timeoutMs);
    }

    protected UIAssertionError(String message, long timeoutMs, Exception cause) {
        super((Object)message);
        this.detailedMessage = message + ErrorMessages.screenshot(this.screenshot) + ErrorMessages.jsErrors(this.jsErrors) + ErrorMessages.timeout(timeoutMs) + ErrorMessages.causedBy(cause);
    }

    public String getMessage() {
        return this.detailedMessage;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public List<String> getJsErrors() {
        return this.jsErrors;
    }
}

