/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Cleanup;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Describe {
    private WebElement element;
    private StringBuilder sb = new StringBuilder();

    Describe(WebElement element) {
        this.element = element;
        this.sb.append('<').append(element.getTagName());
    }

    Describe appendAttributes() {
        return this.supportsJavascriptAttributes() ? this.appendAllAttributes() : this.appendPredefinedAttributes();
    }

    private Describe appendAllAttributes() {
        Map map = (Map)Selenide.executeJavaScript("var s = {};var attrs = arguments[0].attributes;for (var i = 0; i < attrs.length; i++) {   var a = attrs[i];    if (a.name != 'style') {     s[a.name] = a.value;   }}return s;", this.element);
        TreeMap sortedByName = new TreeMap(map);
        for (Map.Entry entry : sortedByName.entrySet()) {
            this.attr((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private Describe appendPredefinedAttributes() {
        return this.attr("id").attr("name").attr("class").attr("href").attr("value").attr("disabled").attr("type").attr("placeholder").attr("onclick").attr("onchange");
    }

    private boolean supportsJavascriptAttributes() {
        return WebDriverRunner.getWebDriver() instanceof JavascriptExecutor && !WebDriverRunner.isHtmlUnit();
    }

    Describe attr(String attributeName) {
        String attributeValue = this.element.getAttribute(attributeName);
        return this.attr(attributeName, attributeValue);
    }

    private Describe attr(String attributeName, String attributeValue) {
        if (attributeValue != null && attributeValue.length() > 0) {
            this.sb.append(' ').append(attributeName).append("=\"").append(attributeValue).append('\"');
        }
        return this;
    }

    public String serialize() {
        String text = this.element.getText();
        this.sb.append('>').append(text == null ? "" : text).append("</").append(this.element.getTagName()).append('>');
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    public String flush() {
        return this.sb.append('>').toString();
    }

    public static String describe(WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            return new Describe(element).appendAttributes().isSelected(element).isDisplayed(element).serialize();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage((Exception)((Object)elementDoesNotExist));
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    public static String shortly(WebElement element) {
        try {
            if (element == null) {
                return "null";
            }
            if (element instanceof SelenideElement) {
                return Describe.shortly(((SelenideElement)element).toWebElement());
            }
            return new Describe(element).attr("id").attr("name").flush();
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage((Exception)((Object)elementDoesNotExist));
        }
        catch (IndexOutOfBoundsException e) {
            return e.toString();
        }
    }

    private Describe isSelected(WebElement element) {
        try {
            if (element.isSelected()) {
                this.sb.append(' ').append("selected:true");
            }
        }
        catch (UnsupportedOperationException ignore) {
        }
        catch (InvalidElementStateException invalidElementStateException) {
            // empty catch block
        }
        return this;
    }

    private Describe isDisplayed(WebElement element) {
        try {
            if (!element.isDisplayed()) {
                this.sb.append(' ').append("displayed:false");
            }
        }
        catch (UnsupportedOperationException e) {
            this.sb.append(' ').append("displayed:").append(e);
        }
        catch (InvalidElementStateException e) {
            this.sb.append(' ').append("displayed:").append((Object)e);
        }
        return this;
    }

    public static String shortly(By selector) {
        if (selector instanceof By.ByCssSelector) {
            return selector.toString().replaceFirst("By\\.selector:\\s*(.*)", "$1").replaceFirst("By\\.cssSelector:\\s*(.*)", "$1");
        }
        return selector.toString();
    }

    public static String selector(By selector) {
        return selector.toString().replaceFirst("By\\.selector:\\s*", "").replaceFirst("By\\.cssSelector:\\s*", "");
    }
}

