/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class PrettyReportCreator
extends TestWatcher {
    private final List<LogEvent> logEvents = new ArrayList<LogEvent>();
    private final LogEventListener logEventListener = new LogEventListener(){

        @Override
        public void onEvent(LogEvent currentLog) {
            PrettyReportCreator.this.logEvents.add(currentLog);
        }
    };

    protected void starting(Description description) {
        SelenideLogger.addListener(this.logEventListener);
    }

    protected void finished(Description description) {
        System.out.println();
        System.out.println("Report for " + description.getDisplayName());
        String hLine = "+--------------------+----------------------------------------------------------------------+----------+----------+";
        System.out.println(hLine);
        System.out.format("|%-20s|%-70s|%-10s|%-10s|\n", "Element", "Subject", "Status", "ms.");
        System.out.println(hLine);
        for (LogEvent e : this.logEvents) {
            System.out.format("|%-20s|%-70s|%-10s|%-10s|\n", new Object[]{e.getElement(), e.getSubject(), e.getStatus(), e.getDuration()});
        }
        System.out.println(hLine);
        System.out.println();
    }
}

