/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ex.ErrorMessages;
import java.util.List;

public class UIAssertionError
extends AssertionError {
    private String screenshot;
    private List<String> jsErrors;
    public long timeoutMs;

    public UIAssertionError(Throwable cause) {
        this(cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
    }

    protected UIAssertionError(String message) {
        super((Object)message);
    }

    protected UIAssertionError(String message, Throwable cause) {
        super(message, cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getLocalizedMessage() + this.uiDetails();
    }

    protected String uiDetails() {
        this.takeCurrentSnapshot();
        return ErrorMessages.screenshot(this.screenshot) + ErrorMessages.jsErrors(this.jsErrors) + ErrorMessages.timeout(this.timeoutMs) + ErrorMessages.causedBy(this.getCause());
    }

    public String getScreenshot() {
        this.takeCurrentSnapshot();
        return this.screenshot;
    }

    public List<String> getJsErrors() {
        this.takeCurrentSnapshot();
        return this.jsErrors;
    }

    private void takeCurrentSnapshot() {
        if (this.screenshot == null) {
            this.screenshot = ErrorMessages.formatScreenShotPath();
        }
        if (this.jsErrors == null) {
            this.jsErrors = Selenide.getJavascriptErrors();
        }
    }
}

