/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.google.common.base.MoreObjects;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class ScreenShotLaboratory {
    private static final Logger log = Logger.getLogger(ScreenShotLaboratory.class.getName());
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected String currentContext = "";
    protected List<String> currentContextScreenshots;
    protected List<String> allScreenshots = new ArrayList<String>();
    protected Set<String> printedErrors = new ConcurrentSkipListSet<String>();

    protected synchronized void printOnce(String action, Throwable error) {
        if (!this.printedErrors.contains(action)) {
            log.log(Level.SEVERE, error.getMessage(), error);
            this.printedErrors.add(action);
        } else {
            log.severe("Failed to " + action + ": " + error);
        }
    }

    public String takeScreenShot(String className, String methodName) {
        return this.takeScreenShot(this.getScreenshotFileName(className, methodName));
    }

    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.timestamp();
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    public String takeScreenShot() {
        return this.takeScreenShot(this.generateScreenshotFileName());
    }

    protected String generateScreenshotFileName() {
        return this.currentContext + this.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    public String takeScreenShot(String fileName) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        File pageSource = this.savePageSourceToFile(fileName, webdriver);
        File imageFile = this.savePageImageToFile(fileName, webdriver);
        String screenshot = ((File)MoreObjects.firstNonNull((Object)imageFile, (Object)pageSource)).getAbsolutePath();
        return this.addToHistory(screenshot);
    }

    public File takeScreenshot(WebElement element) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warning("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        File screen = (File)((TakesScreenshot)webdriver).getScreenshotAs(OutputType.FILE);
        Point p = element.getLocation();
        Dimension elementSize = element.getSize();
        try {
            BufferedImage img = ImageIO.read(screen);
            BufferedImage dest = img.getSubimage(p.getX(), p.getY(), elementSize.getWidth(), elementSize.getHeight());
            ImageIO.write((RenderedImage)dest, "png", screen);
            File screenshotOfElement = new File(this.generateScreenshotFileName());
            FileUtils.copyFile((File)screen, (File)screenshotOfElement);
            return screenshotOfElement;
        }
        catch (IOException e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
    }

    public File getScreenShotAsFile() {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        File scrFile = this.getPageImage(webdriver);
        String screenshot = scrFile.getAbsolutePath();
        this.addToHistory(screenshot);
        return scrFile;
    }

    protected File savePageImageToFile(String fileName, WebDriver webdriver) {
        WebDriver remoteDriver;
        File imageFile = null;
        if (webdriver instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage((TakesScreenshot)webdriver, fileName);
        } else if (webdriver instanceof RemoteWebDriver && (remoteDriver = new Augmenter().augment(webdriver)) instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage((TakesScreenshot)remoteDriver, fileName);
        }
        return imageFile;
    }

    protected File getPageImage(WebDriver webdriver) {
        WebDriver remoteDriver;
        File scrFile = null;
        if (webdriver instanceof TakesScreenshot) {
            scrFile = this.takeScreenshotInMemory((TakesScreenshot)webdriver);
        } else if (webdriver instanceof RemoteWebDriver && (remoteDriver = new Augmenter().augment(webdriver)) instanceof TakesScreenshot) {
            scrFile = this.takeScreenshotInMemory((TakesScreenshot)remoteDriver);
        }
        return scrFile;
    }

    protected File savePageSourceToFile(String fileName, WebDriver webdriver) {
        return this.savePageSourceToFile(fileName, webdriver, true);
    }

    protected File savePageSourceToFile(String fileName, WebDriver webdriver, boolean retryIfAlert) {
        File pageSource = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            this.writeToFile(webdriver.getPageSource(), pageSource);
        }
        catch (UnhandledAlertException e) {
            if (retryIfAlert) {
                try {
                    Alert alert = webdriver.switchTo().alert();
                    log.severe((Object)((Object)e) + ": " + alert.getText());
                    alert.accept();
                    this.savePageSourceToFile(fileName, webdriver, false);
                }
                catch (Exception unableToCloseAlert) {
                    log.severe("Failed to close alert: " + unableToCloseAlert);
                }
            } else {
                this.printOnce("savePageSourceToFile", e);
            }
        }
        catch (UnreachableBrowserException e) {
            this.writeToFile(e.toString(), pageSource);
            return pageSource;
        }
        catch (Exception e) {
            this.writeToFile(e.toString(), pageSource);
            this.printOnce("savePageSourceToFile", e);
        }
        return pageSource;
    }

    protected String addToHistory(String screenshot) {
        if (this.currentContextScreenshots != null) {
            this.currentContextScreenshots.add(screenshot);
        }
        this.allScreenshots.add(screenshot);
        return screenshot;
    }

    protected File takeScreenshotImage(TakesScreenshot driver, String fileName) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(Configuration.reportsFolder, fileName + ".png");
            this.copyFile(scrFile, imageFile);
            return imageFile;
        }
        catch (Exception e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
    }

    protected File takeScreenshotInMemory(TakesScreenshot driver) {
        try {
            return (File)driver.getScreenshotAs(OutputType.FILE);
        }
        catch (Exception e) {
            this.printOnce("takeScreenshotAsFile", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);){
            this.copyFile(in, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(InputStream in, File targetFile) throws IOException {
        this.ensureFolderExists(targetFile);
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(String content, File targetFile) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            this.copyFile(in, targetFile);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to write file " + targetFile.getAbsolutePath(), e);
        }
    }

    protected File ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            log.info("Creating folder: " + folder);
            if (!folder.mkdirs()) {
                log.severe("Failed to create " + folder);
            }
        }
        return targetFile;
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext = context;
        this.currentContextScreenshots = new ArrayList<String>();
    }

    public List<String> finishContext() {
        List<String> result = this.currentContextScreenshots;
        this.currentContext = "";
        this.currentContextScreenshots = null;
        return result;
    }

    public List<String> getScreenshots() {
        return this.allScreenshots;
    }
}

