/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.logging.Logger;

public class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    public static String baseUrl = System.getProperty("selenide.baseUrl", "http://localhost:8080");
    public static long timeout = Long.parseLong(System.getProperty("selenide.timeout", "4000"));
    public static long pollingInterval = Long.parseLong(System.getProperty("selenide.pollingInterval", "100"));
    public static boolean holdBrowserOpen = Boolean.getBoolean("selenide.holdBrowserOpen");
    public static long openBrowserTimeoutMs = Long.parseLong(System.getProperty("selenide.openBrowserTimeout", "15000"));
    public static long closeBrowserTimeoutMs = Long.parseLong(System.getProperty("selenide.closeBrowserTimeout", "5000"));
    public static String browser = System.getProperty("selenide.browser", System.getProperty("browser", "firefox"));
    public static String remote = System.getProperty("remote");
    public static boolean startMaximized = Boolean.parseBoolean(System.getProperty("selenide.start-maximized", "true"));
    public static boolean clickViaJs = Boolean.parseBoolean(System.getProperty("selenide.click-via-js", "false"));
    public static boolean screenshots = Boolean.parseBoolean(System.getProperty("selenide.screenshots", "true"));
    public static String reportsFolder = System.getProperty("selenide.reports", "build/reports/tests");
    public static String reportsUrl = Configuration.getReportsUrl();
    public static boolean dismissModalDialogs = Boolean.parseBoolean(System.getProperty("selenide.dismissModalDialogs", "false"));
    public static boolean fastSetValue = Boolean.parseBoolean(System.getProperty("selenide.fastSetValue", "false"));
    public static SelectorMode selectorMode = SelectorMode.CSS;
    public static AssertionMode assertionMode = AssertionMode.STRICT;

    static String getReportsUrl() {
        String reportsUrl = System.getProperty("selenide.reportsUrl");
        if (Configuration.isEmpty(reportsUrl)) {
            reportsUrl = Configuration.getJenkinsReportsUrl();
            if (Configuration.isEmpty(reportsUrl)) {
                LOG.config("Variable selenide.reportsUrl not found");
            }
        } else {
            LOG.config("Using variable selenide.reportsUrl=" + reportsUrl);
        }
        return reportsUrl;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!Configuration.isEmpty(build_url)) {
            LOG.config("Using Jenkins BUILD_URL: " + build_url);
            return build_url + "artifact/";
        }
        LOG.config("No BUILD_URL variable found. It's not Jenkins.");
        return null;
    }

    public static enum AssertionMode {
        STRICT,
        SOFT;

    }

    public static enum SelectorMode {
        CSS,
        Sizzle;

    }
}

