/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.SelenideElementListIterator;
import com.codeborne.selenide.impl.SelenideLog;
import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.codeborne.selenide.logevents.LogEvent;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ElementsCollection
extends AbstractList<SelenideElement> {
    private final WebElementsCollection collection;
    private List<WebElement> actualElements;
    private Exception lastError;

    public ElementsCollection(WebElementsCollection collection) {
        this.collection = collection;
    }

    public ElementsCollection shouldHaveSize(int expectedSize) {
        return this.shouldHave(CollectionCondition.size(expectedSize));
    }

    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", conditions);
    }

    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", conditions);
    }

    protected ElementsCollection should(String prefix, CollectionCondition ... conditions) {
        SelenideLog log = SelenideLogger.beginStep(this.collection.description(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, Configuration.timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASSED);
            return this;
        }
        catch (Error error) {
            SelenideLogger.commitStep(log, error);
            switch (Configuration.assertionMode) {
                case SOFT: {
                    return this;
                }
            }
            throw UIAssertionError.wrap(error);
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, long timeoutMs) {
        this.lastError = null;
        long startTime = System.currentTimeMillis();
        do {
            block4: {
                try {
                    this.actualElements = this.collection.getActualElements();
                    if (condition.apply(this.actualElements)) {
                        return;
                    }
                }
                catch (WebDriverException elementNotFound) {
                    this.lastError = elementNotFound;
                    if (!Cleanup.of.isInvalidSelectorError(elementNotFound)) break block4;
                    throw Cleanup.of.wrap(elementNotFound);
                }
            }
            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        condition.fail(this.collection, this.actualElements, this.lastError, timeoutMs);
    }

    public ElementsCollection filter(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    public ElementsCollection filterBy(Condition condition) {
        return this.filter(condition);
    }

    public ElementsCollection exclude(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    public ElementsCollection excludeWith(Condition condition) {
        return this.exclude(condition);
    }

    public SelenideElement find(Condition condition) {
        return this.filter(condition).get(0);
    }

    public SelenideElement findBy(Condition condition) {
        return this.find(condition);
    }

    private List<WebElement> getActualElements() {
        if (this.actualElements == null) {
            this.actualElements = this.collection.getActualElements();
        }
        return this.actualElements;
    }

    public String[] getTexts() {
        return ElementsCollection.getTexts(this.getActualElements());
    }

    public static String[] getTexts(Collection<WebElement> elements) {
        String[] texts = new String[elements.size()];
        int i = 0;
        for (WebElement element : elements) {
            texts[i++] = ElementsCollection.getText(element);
        }
        return texts;
    }

    private static String getText(WebElement element) {
        try {
            return element.getText();
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    public static String elementsToString(Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[\n\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",\n\t");
            }
            sb.append(Selenide.$(element));
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    @Override
    public int size() {
        return this.getActualElements().size();
    }

    @Override
    public Iterator<SelenideElement> iterator() {
        return new SelenideElementIterator(this.getActualElements().iterator());
    }

    @Override
    public ListIterator<SelenideElement> listIterator(int index) {
        return new SelenideElementListIterator(this.getActualElements().listIterator(index));
    }

    @Override
    public String toString() {
        try {
            return ElementsCollection.elementsToString(this.getActualElements());
        }
        catch (Exception e) {
            return String.format("[%s]", Cleanup.of.webdriverExceptionMessage(e));
        }
    }
}

