/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Cleanup;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer {
    private static final Logger log = Logger.getLogger(WebDriverThreadLocalContainer.class.getName());
    protected List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    protected Collection<Thread> ALL_WEB_DRIVERS_THREADS = new ConcurrentLinkedQueue<Thread>();
    protected Map<Long, WebDriver> THREAD_WEB_DRIVER = new ConcurrentHashMap<Long, WebDriver>(4);
    protected Proxy webProxySettings;
    protected final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    protected void closeUnusedWebdrivers() {
        for (Thread thread : this.ALL_WEB_DRIVERS_THREADS) {
            if (thread.isAlive()) continue;
            log.info("Thread " + thread.getId() + " is dead. Let's close webdriver " + this.THREAD_WEB_DRIVER.get(thread.getId()));
            this.closeWebDriver(thread);
        }
    }

    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    public WebDriver setWebDriver(WebDriver webDriver) {
        this.THREAD_WEB_DRIVER.put(Thread.currentThread().getId(), webDriver);
        return webDriver;
    }

    public void setProxy(Proxy webProxy) {
        this.webProxySettings = webProxy;
    }

    protected boolean isBrowserStillOpen(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return true;
        }
        catch (UnreachableBrowserException e) {
            log.log(Level.FINE, "Browser is unreachable", e);
            return false;
        }
        catch (NoSuchWindowException e) {
            log.log(Level.FINE, "Browser window is now found", e);
            return false;
        }
        catch (SessionNotFoundException e) {
            log.log(Level.FINE, "Browser session is not found", e);
            return false;
        }
    }

    public boolean hasWebDriverStarted() {
        return this.THREAD_WEB_DRIVER.containsKey(Thread.currentThread().getId());
    }

    public WebDriver getWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            return webDriver;
        }
        log.info("No webdriver is bound to current thread: " + Thread.currentThread().getId() + " - let's create new webdriver");
        return this.setWebDriver(this.createDriver());
    }

    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            if (this.isBrowserStillOpen(webDriver)) {
                return webDriver;
            }
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
        }
        return this.setWebDriver(this.createDriver());
    }

    public void closeWebDriver() {
        this.closeWebDriver(Thread.currentThread());
    }

    protected void closeWebDriver(Thread thread) {
        this.ALL_WEB_DRIVERS_THREADS.remove(thread);
        WebDriver webdriver = this.THREAD_WEB_DRIVER.remove(thread.getId());
        if (webdriver != null && !Configuration.holdBrowserOpen) {
            log.info("Close webdriver: " + thread.getId() + " -> " + webdriver);
            long start = System.currentTimeMillis();
            Thread t = new Thread(new CloseBrowser(webdriver));
            t.setDaemon(true);
            t.start();
            try {
                t.join(Configuration.closeBrowserTimeoutMs);
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, "Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds", e);
            }
            long duration = System.currentTimeMillis() - start;
            if (duration >= Configuration.closeBrowserTimeoutMs) {
                log.severe("Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds");
            } else if (duration > 200L) {
                log.info("Closed webdriver in " + duration + " ms");
            } else {
                log.fine("Closed webdriver in " + duration + " ms");
            }
        }
    }

    public void clearBrowserCache() {
        WebDriver webdriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    protected WebDriver createDriver() {
        WebDriver webdriver = this.createWebDriverWithTimeout();
        webdriver = this.maximize(webdriver);
        log.info("Create webdriver in current thread " + Thread.currentThread().getId() + ": " + Configuration.browser + " -> " + webdriver);
        return this.markForAutoClose(this.addListeners(webdriver));
    }

    protected WebDriver createWebDriverWithTimeout() {
        for (int i = 0; i < 3; ++i) {
            CreateWebdriver create = new CreateWebdriver();
            Thread t = new Thread(create);
            t.setDaemon(true);
            t.start();
            try {
                t.join(Configuration.openBrowserTimeoutMs);
                if (create.webdriver == null) continue;
                return create.webdriver;
            }
            catch (InterruptedException e) {
                throw this.runtime(e);
            }
        }
        throw new RuntimeException("Could not create webdriver in " + Configuration.openBrowserTimeoutMs + " ms");
    }

    protected WebDriver addListeners(WebDriver webdriver) {
        if (this.listeners.isEmpty()) {
            return webdriver;
        }
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : this.listeners) {
            log.info("Add listener to webdriver: " + listener);
            wrapper.register(listener);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebDriver markForAutoClose(WebDriver webDriver) {
        this.ALL_WEB_DRIVERS_THREADS.add(Thread.currentThread());
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread().start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new WebdriversFinalCleanupThread(webDriver, Thread.currentThread()));
        return webDriver;
    }

    protected WebDriver createChromeDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"test-type"});
        capabilities.setCapability("chromeOptions", (Object)options);
        return new ChromeDriver((Capabilities)capabilities);
    }

    protected WebDriver createFirefoxDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        return new FirefoxDriver((Capabilities)capabilities);
    }

    protected WebDriver createHtmlUnitDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnitWithJs();
        capabilities.merge((Capabilities)this.createCommonCapabilities());
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver() {
        DesiredCapabilities capabilities = this.createCommonCapabilities();
        return new InternetExplorerDriver((Capabilities)capabilities);
    }

    protected WebDriver createPhantomJsDriver() {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver");
    }

    protected WebDriver createOperaDriver() {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver");
    }

    protected WebDriver createSafariDriver() {
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver");
    }

    protected WebDriver maximize(WebDriver driver) {
        if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                log.warning("Cannot maximize " + Configuration.browser + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenResolution = new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    protected WebDriver createInstanceOf(String className) {
        try {
            Class<?> clazz;
            DesiredCapabilities capabilities = this.createCommonCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            if (WebDriverRunner.isPhantomjs()) {
                capabilities.setCapability("phantomjs.cli.args", (Object)new String[]{"--web-security=no", "--ignore-ssl-errors=yes"});
            }
            if (WebDriverProvider.class.isAssignableFrom(clazz = Class.forName(className))) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }

    protected WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    protected DesiredCapabilities createCommonCapabilities() {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (this.webProxySettings != null) {
            browserCapabilities.setCapability("proxy", (Object)this.webProxySettings);
        }
        return browserCapabilities;
    }

    protected class UnusedWebdriversCleanupThread
    extends Thread {
        public UnusedWebdriversCleanupThread() {
            this.setDaemon(true);
            this.setName("Webdrivers killer thread");
        }

        @Override
        public void run() {
            while (true) {
                WebDriverThreadLocalContainer.this.closeUnusedWebdrivers();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    protected class WebdriversFinalCleanupThread
    extends Thread {
        private final WebDriver webDriver;
        private final Thread thread;

        public WebdriversFinalCleanupThread(WebDriver webDriver, Thread thread) {
            this.webDriver = webDriver;
            this.thread = thread;
        }

        @Override
        public void run() {
            WebDriverThreadLocalContainer.this.ALL_WEB_DRIVERS_THREADS.remove(this.thread);
            new CloseBrowser(this.webDriver).run();
        }
    }

    private class CreateWebdriver
    implements Runnable {
        WebDriver webdriver = null;

        private CreateWebdriver() {
        }

        @Override
        public void run() {
            try {
                log.config("Configuration.browser=" + Configuration.browser);
                log.config("Configuration.remote=" + Configuration.remote);
                log.config("Configuration.startMaximized=" + Configuration.startMaximized);
                this.webdriver = Configuration.remote != null ? WebDriverThreadLocalContainer.this.createRemoteDriver(Configuration.remote, Configuration.browser) : ("chrome".equalsIgnoreCase(Configuration.browser) ? WebDriverThreadLocalContainer.this.createChromeDriver() : (WebDriverRunner.isFirefox() ? WebDriverThreadLocalContainer.this.createFirefoxDriver() : (WebDriverRunner.isHtmlUnit() ? WebDriverThreadLocalContainer.this.createHtmlUnitDriver() : (WebDriverRunner.isIE() ? WebDriverThreadLocalContainer.this.createInternetExplorerDriver() : (WebDriverRunner.isPhantomjs() ? WebDriverThreadLocalContainer.this.createPhantomJsDriver() : (WebDriverRunner.isOpera() ? WebDriverThreadLocalContainer.this.createOperaDriver() : (WebDriverRunner.isSafari() ? WebDriverThreadLocalContainer.this.createSafariDriver() : WebDriverThreadLocalContainer.this.createInstanceOf(Configuration.browser))))))));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to create webdriver", e);
            }
        }
    }

    private static class CloseBrowser
    implements Runnable {
        private final WebDriver webdriver;

        private CloseBrowser(WebDriver webdriver) {
            this.webdriver = webdriver;
        }

        @Override
        public void run() {
            try {
                log.info("Trying to close the browser " + this.webdriver + " ...");
                this.webdriver.quit();
            }
            catch (UnreachableBrowserException e) {
                log.log(Level.FINE, "Browser is unreachable", e);
            }
            catch (WebDriverException cannotCloseBrowser) {
                log.severe("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
            }
            finally {
                this.killBrowser(this.webdriver);
            }
        }

        protected void killBrowser(WebDriver webdriver) {
            if (webdriver instanceof Killable) {
                try {
                    ((Killable)webdriver).kill();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to kill browser " + webdriver + ':', e);
                }
            }
        }
    }
}

