/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.ErrorsCollector;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SoftAsserts
extends ExternalResource {
    private Description currentTest;
    private final ErrorsCollector errorsCollector = new ErrorsCollector();

    public SoftAsserts() {
        SelenideLogger.addListener(this.errorsCollector);
    }

    public Statement apply(Statement base, Description description) {
        this.currentTest = description;
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.errorsCollector.clear();
    }

    protected void after() {
        this.errorsCollector.failIfErrors(this.currentTest.getDisplayName());
    }
}

