/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.AbstractSelenideElement;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WebElementSelector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WaitingSelenideElement
extends AbstractSelenideElement {
    private final SearchContext parent;
    private final By criteria;
    private final int index;

    public static SelenideElement wrap(By criteria) {
        return WaitingSelenideElement.wrap(null, criteria, 0);
    }

    public static SelenideElement wrap(SearchContext parent, By criteria, int index) {
        return (SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new WaitingSelenideElement(parent, criteria, index));
    }

    WaitingSelenideElement(SearchContext parent, By criteria, int index) {
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    @Override
    protected WebElement getDelegate() {
        return this.getActualDelegate();
    }

    @Override
    protected SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return arg instanceof By ? WaitingSelenideElement.wrap((SearchContext)proxy, (By)arg, index) : WaitingSelenideElement.wrap((SearchContext)proxy, By.cssSelector((String)((String)arg)), index);
    }

    @Override
    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElement(this.getSearchContext(), this.criteria) : WebElementSelector.instance.findElements(this.getSearchContext(), this.criteria).get(this.index);
    }

    @Override
    protected List<WebElement> getAllMatchingElements() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElements(this.getSearchContext(), this.criteria) : super.getAllMatchingElements();
    }

    private SearchContext getSearchContext() {
        return this.parent == null ? WebDriverRunner.getWebDriver() : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).toWebElement() : this.parent);
    }

    @Override
    protected ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.parent instanceof SelenideElement) {
            ((SelenideElement)this.parent).should(Condition.exist);
        } else if (this.parent instanceof WebElement) {
            Selenide.$((WebElement)this.parent).should(Condition.exist);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    @Override
    String getSearchCriteria() {
        return this.index == 0 ? Describe.selector(this.criteria) : Describe.selector(this.criteria) + '[' + this.index + ']';
    }

    public String toString() {
        return "{" + this.getSearchCriteria() + '}';
    }
}

