/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebDriverRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private final WebDriver.TargetLocator delegate;

    SelenideTargetLocator(WebDriver.TargetLocator delegate) {
        this.delegate = delegate;
    }

    public WebDriver frame(int index) {
        return this.delegate.frame(index);
    }

    public WebDriver frame(String nameOrId) {
        return this.delegate.frame(nameOrId);
    }

    public WebDriver frame(WebElement frameElement) {
        return this.delegate.frame(frameElement);
    }

    public WebDriver parentFrame() {
        return this.delegate.parentFrame();
    }

    public WebDriver defaultContent() {
        return this.delegate.defaultContent();
    }

    public WebElement activeElement() {
        return this.delegate.activeElement();
    }

    public Alert alert() {
        return this.delegate.alert();
    }

    public WebDriver innerFrame(String ... frames) {
        WebDriver driver = WebDriverRunner.getWebDriver();
        this.delegate.defaultContent();
        for (String frame : frames) {
            try {
                String selector = String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame);
                this.delegate.frame(driver.findElement(By.cssSelector((String)selector)));
            }
            catch (NoSuchElementException e) {
                throw new NoSuchFrameException("No frame found with id/name = " + frame, (Throwable)e);
            }
        }
        return driver;
    }

    public WebDriver window(int index) {
        WebDriver driver = WebDriverRunner.getWebDriver();
        ArrayList windowHandles = new ArrayList(driver.getWindowHandles());
        this.delegate.window((String)windowHandles.get(index));
        return driver;
    }

    public WebDriver window(String nameOrHandleOrTitle) {
        try {
            return this.delegate.window(nameOrHandleOrTitle);
        }
        catch (NoSuchWindowException windowWithNameOrTitleNotFound) {
            return this.windowExceptHandles(nameOrHandleOrTitle, new String[0]);
        }
    }

    protected WebDriver windowExceptHandles(String nameOrHandleOrTitle, String ... exceptHandles) {
        WebDriver driver = WebDriverRunner.getWebDriver();
        Set windowHandles = driver.getWindowHandles();
        windowHandles.removeAll(Arrays.asList(exceptHandles));
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (!nameOrHandleOrTitle.equals(driver.getTitle())) continue;
            return driver;
        }
        throw new NoSuchWindowException("Window with id/name/title not found: " + nameOrHandleOrTitle);
    }
}

