/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.SelenideLog;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SelenideLogger {
    protected static ThreadLocal<List<LogEventListener>> listeners = new ThreadLocal();

    public static void addListener(LogEventListener listener) {
        List<LogEventListener> list = listeners.get();
        if (list == null) {
            list = new ArrayList<LogEventListener>();
        }
        list.add(listener);
        listeners.set(list);
    }

    public static SelenideLog beginStep(String source, String methodName, Object ... args) {
        return SelenideLogger.beginStep(source, SelenideLogger.readableMethodName(methodName) + "(" + SelenideLogger.readableArguments(args) + ")");
    }

    static String readableMethodName(String methodName) {
        return methodName.replaceAll("([A-Z])", " $1").toLowerCase();
    }

    static String readableArguments(Object ... args) {
        return args == null ? "" : (args[0] instanceof Object[] ? SelenideLogger.arrayToString((Object[])args[0]) : SelenideLogger.arrayToString(args));
    }

    private static String arrayToString(Object[] args) {
        return args.length == 1 ? String.valueOf(args[0]) : Arrays.toString(args);
    }

    public static SelenideLog beginStep(String source, String subject) {
        return new SelenideLog(source, subject);
    }

    public static void commitStep(SelenideLog log, Throwable error) {
        log.setError(error);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.FAILED);
    }

    public static void commitStep(SelenideLog log, LogEvent.EventStatus status) {
        log.setStatus(status);
        List<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        for (LogEventListener listener : listeners) {
            listener.onEvent(log);
        }
    }

    private static List<LogEventListener> getEventLoggerListeners() {
        if (listeners.get() == null) {
            listeners.set(new ArrayList());
        }
        return listeners.get();
    }

    @Deprecated
    public static void clearListeners() {
        listeners.remove();
    }

    public static void removeListener(LogEventListener listener) {
        listeners.get().remove(listener);
        if (listeners.get().isEmpty()) {
            listeners.remove();
        }
    }
}

