/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.impl.SelenideLogger;
import com.codeborne.selenide.logevents.EventsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.logging.Logger;

public class SimpleReport {
    private static final Logger log = Logger.getLogger(SimpleReport.class.getName());
    private EventsCollector logEventListener;

    public void start() {
        this.logEventListener = new EventsCollector();
        SelenideLogger.addListener(this.logEventListener);
    }

    public void finish(String title) {
        SelenideLogger.removeListener(this.logEventListener);
        StringBuilder sb = new StringBuilder();
        sb.append("Report for ").append(title).append('\n');
        String delimiter = '+' + Joiner.on((char)'+').join((Object)this.line(20), (Object)this.line(70), new Object[]{this.line(10), this.line(10)}) + "+\n";
        sb.append(delimiter);
        sb.append(String.format("|%-20s|%-70s|%-10s|%-10s|%n", "Element", "Subject", "Status", "ms."));
        sb.append(delimiter);
        for (LogEvent e : this.logEventListener.events()) {
            sb.append(String.format("|%-20s|%-70s|%-10s|%-10s|%n", new Object[]{e.getElement(), e.getSubject(), e.getStatus(), e.getDuration()}));
        }
        sb.append(delimiter);
        log.info(sb.toString());
    }

    private String line(int count) {
        return Joiner.on((String)"").join(Collections.nCopies(count, "-"));
    }
}

